/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.acmt;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.format.acmt.Account;
import de.businesslogics.format.acmt.AccountLimitInfo;
import de.businesslogics.format.acmt.LimitType;
import de.businesslogics.format.iso20022.acmt01700102.AccountForAction1;
import de.businesslogics.format.iso20022.acmt01700102.AccountIdentification4Choice;
import de.businesslogics.format.iso20022.acmt01700102.AccountMandateMaintenanceRequestV02;
import de.businesslogics.format.iso20022.acmt01700102.ActiveCurrencyAndAmount;
import de.businesslogics.format.iso20022.acmt01700102.ActiveCurrencyCode;
import de.businesslogics.format.iso20022.acmt01700102.Authorisation2;
import de.businesslogics.format.iso20022.acmt01700102.BICFIIdentifier;
import de.businesslogics.format.iso20022.acmt01700102.BankTransactionCodeStructure4;
import de.businesslogics.format.iso20022.acmt01700102.BranchAndFinancialInstitutionIdentification5;
import de.businesslogics.format.iso20022.acmt01700102.Channel2Choice;
import de.businesslogics.format.iso20022.acmt01700102.Document;
import de.businesslogics.format.iso20022.acmt01700102.FinancialInstitutionIdentification8;
import de.businesslogics.format.iso20022.acmt01700102.FixedAmountOrUnlimited1Choice;
import de.businesslogics.format.iso20022.acmt01700102.GenericOrganisationIdentification1;
import de.businesslogics.format.iso20022.acmt01700102.Group2;
import de.businesslogics.format.iso20022.acmt01700102.IBAN2007Identifier;
import de.businesslogics.format.iso20022.acmt01700102.ISODateTime;
import de.businesslogics.format.iso20022.acmt01700102.Max140Text;
import de.businesslogics.format.iso20022.acmt01700102.Max15PlusSignedNumericText;
import de.businesslogics.format.iso20022.acmt01700102.Max35Text;
import de.businesslogics.format.iso20022.acmt01700102.Max3NumericText;
import de.businesslogics.format.iso20022.acmt01700102.Max4AlphaNumericText;
import de.businesslogics.format.iso20022.acmt01700102.MaximumAmountByPeriod1;
import de.businesslogics.format.iso20022.acmt01700102.MessageIdentification1;
import de.businesslogics.format.iso20022.acmt01700102.Modification1Code;
import de.businesslogics.format.iso20022.acmt01700102.OperationMandate3;
import de.businesslogics.format.iso20022.acmt01700102.Organisation14;
import de.businesslogics.format.iso20022.acmt01700102.OrganisationIdentification8;
import de.businesslogics.format.iso20022.acmt01700102.OrganisationIdentificationSchemeName1Choice;
import de.businesslogics.format.iso20022.acmt01700102.PartyAndAuthorisation3;
import de.businesslogics.format.iso20022.acmt01700102.PartyAndCertificate3;
import de.businesslogics.format.iso20022.acmt01700102.PartyIdentification43;
import de.businesslogics.format.iso20022.acmt01700102.PartyOrGroup1Choice;
import de.businesslogics.format.iso20022.acmt01700102.ProprietaryBankTransactionCodeStructure1;
import de.businesslogics.format.iso20022.acmt01700102.References4;
import de.businesslogics.format.iso20022.acmt01700102.Unlimited9Text;
import de.businesslogics.format.iso20022.acmt01700102.YesNoIndicator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.xml.sax.SAXException;

public class Acmt01700102Writer {
    private static final Max35Text EBICS = new Max35Text("EBICS");
    private static final Max35Text OPERATION_MANDATE_I1 = new Max35Text("I1");
    private static final String reqrdSgntrNb = "0";
    private static final boolean sgntrOrdrInd = false;
    private static final Modification1Code MOD_CODE_MODI = new Modification1Code("MODI");
    private static final Modification1Code MOD_CODE_NOCH = new Modification1Code("NOCH");
    private static final Max4AlphaNumericText GROUP_I1 = new Max4AlphaNumericText("I1");
    private static final Max35Text CHANNEL_IPR = new Max35Text("IPR");
    private static final Max35Text BANK_OPERATION_CIP = new Max35Text("CIP");
    private static final Max140Text DEFAULT_USER_ID = new Max140Text("*");
    private static final Unlimited9Text UNLIMITED = new Unlimited9Text("UNLIMITED");

    public static void write(OutputStream out, String messageId, String processId, String customerId, AccountLimitInfo accountLimitInfo) throws IOException, SAXException {
        EbicsElement d = Acmt01700102Writer.getDocument(messageId, processId, customerId, accountLimitInfo);
        EbicsPrintStream eps = new EbicsPrintStream(out);
        boolean prettyXML = true;
        eps.setPretty(prettyXML);
        eps.printOutPossibleRoot(d);
    }

    private static EbicsElement getDocument(String messageId, String processId, String customerId, AccountLimitInfo accountLimitInfo) {
        EbicsElement choice;
        ISODateTime dateTime = new ISODateTime(new Date());
        MessageIdentification1 msgId = new MessageIdentification1(new Max35Text(messageId), dateTime);
        MessageIdentification1 prcId = new MessageIdentification1(new Max35Text(processId), dateTime);
        References4 references = new References4(msgId, prcId);
        Account account = accountLimitInfo.getAccount();
        FinancialInstitutionIdentification8 financialinstitution = new FinancialInstitutionIdentification8();
        financialinstitution.setBICFI(new BICFIIdentifier(account.getBic()));
        BranchAndFinancialInstitutionIdentification5 institution = new BranchAndFinancialInstitutionIdentification5(financialinstitution);
        GenericOrganisationIdentification1 genericOrganisationIdentification = new GenericOrganisationIdentification1(new Max35Text(customerId));
        OrganisationIdentificationSchemeName1Choice schemeName = new OrganisationIdentificationSchemeName1Choice(OrganisationIdentificationSchemeName1Choice.C1.fromPrtry(EBICS));
        genericOrganisationIdentification.setSchmeNm(schemeName);
        OrganisationIdentification8 organisationIdentification = new OrganisationIdentification8();
        organisationIdentification.getOthrs().add(genericOrganisationIdentification);
        Organisation14 organisation = new Organisation14(organisationIdentification);
        AccountMandateMaintenanceRequestV02 maintenanceRequest = new AccountMandateMaintenanceRequestV02(references, institution, organisation);
        IBAN2007Identifier iban = new IBAN2007Identifier(account.getIban());
        AccountIdentification4Choice accountIdentification = new AccountIdentification4Choice(AccountIdentification4Choice.C1.fromIBAN(iban));
        ActiveCurrencyCode currency = new ActiveCurrencyCode(account.getCurrencyCode());
        AccountForAction1 accountForAction = new AccountForAction1(accountIdentification, currency);
        maintenanceRequest.getAcctIds().add(accountForAction);
        OperationMandate3 mandate = new OperationMandate3(OPERATION_MANDATE_I1, new Max15PlusSignedNumericText(reqrdSgntrNb), new YesNoIndicator(false));
        mandate.setModCd(MOD_CODE_MODI);
        mandate.getAplblChanls().add(new Channel2Choice(Channel2Choice.C1.fromPrtry(CHANNEL_IPR)));
        Authorisation2 autorisation = new Authorisation2();
        ActiveCurrencyAndAmount amt = new ActiveCurrencyAndAmount(accountLimitInfo.getAmount(), new ActiveCurrencyCode(account.getCurrencyCode()));
        if (LimitType.TRANSACTION_LIMIT.equals((Object)accountLimitInfo.getLimitType())) {
            choice = new FixedAmountOrUnlimited1Choice(FixedAmountOrUnlimited1Choice.C1.fromAmt(amt));
            autorisation.setMaxAmtByTx((FixedAmountOrUnlimited1Choice)choice);
        } else if (LimitType.DAY_LIMIT.equals((Object)accountLimitInfo.getLimitType())) {
            int numberOfDays = 1;
            MaximumAmountByPeriod1 maxAmtByPeriod = new MaximumAmountByPeriod1(amt, new Max3NumericText(String.valueOf(numberOfDays)));
            autorisation.getMaxAmtByPrds().add(maxAmtByPeriod);
        } else {
            choice = new FixedAmountOrUnlimited1Choice(FixedAmountOrUnlimited1Choice.C1.fromNotLtd(UNLIMITED));
            autorisation.setMaxAmtByTx((FixedAmountOrUnlimited1Choice)choice);
        }
        choice = new PartyOrGroup1Choice(PartyOrGroup1Choice.C1.fromGrpId(GROUP_I1));
        PartyAndAuthorisation3 partyAndAuthorisation = new PartyAndAuthorisation3((PartyOrGroup1Choice)choice, autorisation);
        partyAndAuthorisation.setModCd(MOD_CODE_MODI);
        mandate.getMndtHldrs().add(partyAndAuthorisation);
        BankTransactionCodeStructure4 bankTransactionCodeStructure = new BankTransactionCodeStructure4();
        ProprietaryBankTransactionCodeStructure1 propStructure = new ProprietaryBankTransactionCodeStructure1(BANK_OPERATION_CIP);
        propStructure.setIssr(EBICS);
        bankTransactionCodeStructure.setPrtry(propStructure);
        mandate.getBkOprs().add(bankTransactionCodeStructure);
        maintenanceRequest.getMndts().add(mandate);
        Group2 group = new Group2(GROUP_I1);
        group.setModCd(MOD_CODE_NOCH);
        PartyIdentification43 partyIdentification = new PartyIdentification43();
        partyIdentification.setNm(DEFAULT_USER_ID);
        PartyAndCertificate3 partyAndCertificate = new PartyAndCertificate3(partyIdentification);
        partyAndCertificate.setModCd(MOD_CODE_NOCH);
        group.getPtys().add(partyAndCertificate);
        maintenanceRequest.getGrps().add(group);
        return new Document(maintenanceRequest);
    }
}

