/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.acmt;

import de.businesslogics.format.acmt.Account;
import de.businesslogics.format.acmt.AccountLimitInfo;
import de.businesslogics.format.acmt.LimitType;
import de.businesslogics.format.iso20022.acmt01400102.AccountIdentification4Choice;
import de.businesslogics.format.iso20022.acmt01400102.AccountReport15;
import de.businesslogics.format.iso20022.acmt01400102.Authorisation2;
import de.businesslogics.format.iso20022.acmt01400102.BICFIIdentifier;
import de.businesslogics.format.iso20022.acmt01400102.CustomerAccount5;
import de.businesslogics.format.iso20022.acmt01400102.Document;
import de.businesslogics.format.iso20022.acmt01400102.MessageIdentification1;
import de.businesslogics.format.iso20022.acmt01400102.OperationMandate2;
import de.businesslogics.format.iso20022.acmt01400102.PartyAndAuthorisation1;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import org.xml.sax.SAXException;

public class Acmt01400102Reader {
    public static List<AccountLimitInfo> readAccountLimitInfos(Document d) throws IOException, SAXException {
        return null;
    }

    public static AccountLimitInfo readAccountLimitInfo(Document d) throws IOException, SAXException {
        BICFIIdentifier bicfi;
        List<AccountReport15> rpts;
        String bic = null;
        String iban = null;
        String currencyCode = null;
        LimitType limitType = null;
        BigDecimal amount = null;
        if (d.getAcctRpt().getRefs().getReqTp().getValue().equals("VIEW")) {
            limitType = LimitType.NO_LIMIT;
        }
        if ((rpts = d.getAcctRpt().getRpts()) != null && !rpts.isEmpty()) {
            List<PartyAndAuthorisation1> mndtHldrs;
            AccountReport15 rpt = rpts.getFirst();
            CustomerAccount5 acct = rpt.getAcct();
            List<AccountIdentification4Choice> ids = acct.getIds();
            if (ids != null && !ids.isEmpty()) {
                iban = ids.getFirst().getChoice1().getIBAN().getValue();
            }
            currencyCode = acct.getCcy().getValue();
            List<OperationMandate2> mndts = rpt.getMndts();
            if (mndts != null && !mndts.isEmpty() && (mndtHldrs = mndts.getFirst().getMndtHldrs()) != null && !mndtHldrs.isEmpty()) {
                Authorisation2 authstn = mndtHldrs.getFirst().getAuthstn();
                if (authstn.getMaxAmtByPrds() != null && !authstn.getMaxAmtByPrds().isEmpty()) {
                    limitType = LimitType.DAY_LIMIT;
                    amount = authstn.getMaxAmtByPrds().getFirst().getMaxAmt().getValue();
                } else if (authstn.getMaxAmtByTx() != null && authstn.getMaxAmtByTx().getChoice1().getAmt() != null) {
                    limitType = LimitType.TRANSACTION_LIMIT;
                    amount = authstn.getMaxAmtByTx().getChoice1().getAmt().getValue();
                }
            }
        }
        if ((bicfi = d.getAcctRpt().getAcctSvcrId().getFinInstnId().getBICFI()) != null) {
            bic = bicfi.getValue();
        }
        Date limitTime = d.getAcctRpt().getRefs().getMsgId().getCreDtTm().getDate();
        String msgId = null;
        List<MessageIdentification1> ackdMsgIds = d.getAcctRpt().getRefs().getAckdMsgIds();
        if (ackdMsgIds != null && !ackdMsgIds.isEmpty()) {
            msgId = ackdMsgIds.getFirst().getId().getValue();
        }
        AccountLimitInfo info = new AccountLimitInfo(new Account(iban, bic, currencyCode), limitType, amount);
        info.setLimitTime(new Timestamp(limitTime.getTime()));
        info.setMsgId(msgId);
        return info;
    }
}

