/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.acmt;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.format.acmt.Account;
import de.businesslogics.format.iso20022.acmt01300102.AccountForAction1;
import de.businesslogics.format.iso20022.acmt01300102.AccountIdentification4Choice;
import de.businesslogics.format.iso20022.acmt01300102.AccountReportRequestV02;
import de.businesslogics.format.iso20022.acmt01300102.ActiveCurrencyCode;
import de.businesslogics.format.iso20022.acmt01300102.BICFIIdentifier;
import de.businesslogics.format.iso20022.acmt01300102.BranchAndFinancialInstitutionIdentification5;
import de.businesslogics.format.iso20022.acmt01300102.Document;
import de.businesslogics.format.iso20022.acmt01300102.FinancialInstitutionIdentification8;
import de.businesslogics.format.iso20022.acmt01300102.GenericOrganisationIdentification1;
import de.businesslogics.format.iso20022.acmt01300102.IBAN2007Identifier;
import de.businesslogics.format.iso20022.acmt01300102.ISODateTime;
import de.businesslogics.format.iso20022.acmt01300102.Max35Text;
import de.businesslogics.format.iso20022.acmt01300102.MessageIdentification1;
import de.businesslogics.format.iso20022.acmt01300102.OrganisationIdentification8;
import de.businesslogics.format.iso20022.acmt01300102.OrganisationIdentificationSchemeName1Choice;
import de.businesslogics.format.iso20022.acmt01300102.References4;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.xml.sax.SAXException;

public class Acmt01300102Writer {
    private static final Max35Text EBICS = new Max35Text("EBICS");

    public static void write(OutputStream out, String messageId, String processId, String customerId, Account account) throws IOException, SAXException {
        EbicsElement d = Acmt01300102Writer.getDocument(messageId, processId, customerId, account);
        EbicsPrintStream eps = new EbicsPrintStream(out);
        boolean prettyXML = true;
        eps.setPretty(prettyXML);
        eps.printOutPossibleRoot(d);
    }

    private static EbicsElement getDocument(String messageId, String processId, String customerId, Account account) {
        ISODateTime dateTime = new ISODateTime(new Date());
        MessageIdentification1 msgId = new MessageIdentification1(new Max35Text(messageId), dateTime);
        MessageIdentification1 prcId = new MessageIdentification1(new Max35Text(processId), dateTime);
        References4 references = new References4(msgId, prcId);
        FinancialInstitutionIdentification8 financialinstitution = new FinancialInstitutionIdentification8();
        financialinstitution.setBICFI(new BICFIIdentifier(account.getBic()));
        BranchAndFinancialInstitutionIdentification5 institution = new BranchAndFinancialInstitutionIdentification5(financialinstitution);
        GenericOrganisationIdentification1 genericOrganisationIdentification = new GenericOrganisationIdentification1(new Max35Text(customerId));
        OrganisationIdentificationSchemeName1Choice schemeName = new OrganisationIdentificationSchemeName1Choice(OrganisationIdentificationSchemeName1Choice.C1.fromPrtry(EBICS));
        genericOrganisationIdentification.setSchmeNm(schemeName);
        OrganisationIdentification8 organisationIdentification = new OrganisationIdentification8();
        organisationIdentification.getOthrs().add(genericOrganisationIdentification);
        AccountReportRequestV02 reportRequest = new AccountReportRequestV02(references, institution, organisationIdentification);
        IBAN2007Identifier iban = new IBAN2007Identifier(account.getIban());
        AccountIdentification4Choice accountIdentification = new AccountIdentification4Choice(AccountIdentification4Choice.C1.fromIBAN(iban));
        ActiveCurrencyCode currency = new ActiveCurrencyCode(account.getCurrencyCode());
        AccountForAction1 accountForAction = new AccountForAction1(accountIdentification, currency);
        reportRequest.getAcctIds().add(accountForAction);
        return new Document(reportRequest);
    }
}

