/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.acmt;

import de.businesslogics.format.acmt.Account;
import de.businesslogics.format.acmt.AccountLimitRejectionInfo;
import de.businesslogics.format.iso20022.acmt01100102.AccountForAction1;
import de.businesslogics.format.iso20022.acmt01100102.BICFIIdentifier;
import de.businesslogics.format.iso20022.acmt01100102.Document;
import de.businesslogics.format.iso20022.acmt01100102.Max350Text;
import de.businesslogics.format.iso20022.acmt01100102.References6;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Acmt01100102Reader {
    public static AccountLimitRejectionInfo readErrorInfo(Document d) {
        BICFIIdentifier bicfi;
        String iban = null;
        String bic = null;
        String currencyCode = null;
        References6 refs = d.getAcctReqRjctn().getRefs();
        List<AccountForAction1> acctIds = d.getAcctReqRjctn().getAcctIds();
        if (acctIds != null && !acctIds.isEmpty()) {
            AccountForAction1 acctId = acctIds.getFirst();
            iban = acctId.getId().getChoice1().getIBAN().getValue();
            currencyCode = acctId.getCcy().getValue();
        }
        if ((bicfi = d.getAcctReqRjctn().getAcctSvcrId().getFinInstnId().getBICFI()) != null) {
            bic = bicfi.getValue();
        }
        ArrayList<String> reasons = new ArrayList<String>();
        List<Max350Text> rjctnRsns = refs.getRjctnRsns();
        for (Max350Text reason : rjctnRsns) {
            reasons.add(reason.getValue().replace("\t", "").replace("\n", "").replaceAll(" +", " "));
        }
        Date limitTime = d.getAcctReqRjctn().getRefs().getMsgId().getCreDtTm().getDate();
        AccountLimitRejectionInfo info = new AccountLimitRejectionInfo(new Account(iban, bic, currencyCode), reasons);
        info.setLimitTime(new Timestamp(limitTime.getTime()));
        return info;
    }
}

