/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format;

import de.businesslogics.format.ptk2.DisplayMessage;
import java.util.Locale;
import java.util.ResourceBundle;

class TextProtocolMessage
implements DisplayMessage {
    private static final long serialVersionUID = 1L;
    private final String[] firstLines;
    private final String[] lastLines;

    TextProtocolMessage(String[] allLines) {
        this(allLines, null);
    }

    TextProtocolMessage(String[] firstLines, String[] lastLines) {
        this.firstLines = firstLines;
        this.lastLines = lastLines;
    }

    @Override
    public void appendText(Locale locale, StringBuilder text) {
        int i;
        ResourceBundle b = ResourceBundle.getBundle("de.businesslogics.format.TextProtocolMessage", locale);
        text.append("    ");
        text.append(b.getString("SEP"));
        if (this.lastLines != null) {
            text.append("\r\n");
            text.append("     ");
            text.append(b.getString("FIRST"));
        }
        for (i = 0; i < this.firstLines.length; ++i) {
            text.append("\r\n");
            text.append("     ");
            text.append(this.firstLines[i]);
        }
        if (this.lastLines != null) {
            text.append("\r\n");
            text.append("\r\n");
            text.append("     ");
            text.append(b.getString("LAST"));
            for (i = 0; i < this.lastLines.length; ++i) {
                text.append("\r\n");
                text.append("     ");
                text.append(this.lastLines[i]);
            }
        }
        text.append("\r\n");
        text.append("    ");
        text.append(b.getString("SEP"));
        text.append("\r\n");
    }
}

