/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format;

import de.businesslogics.format.TextProtocolMessage;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class TextOutputStream
extends OutputStream
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int MAX_LINE_LENGTH = 67;
    private static final int RECORD_LINES = 5;
    protected final StringBuilder line = new StringBuilder();
    private final List<String> firstLines = new ArrayList<String>();
    private final LinkedList<String> lastLines = new LinkedList();
    private int state = 0;
    private TextProtocolMessage displayMessage;
    private final int maxLineLength;
    private final Charset charset;

    public TextOutputStream() {
        this.maxLineLength = 67;
        this.charset = null;
    }

    protected TextOutputStream(int maxLineLength, Charset charset) {
        this.maxLineLength = maxLineLength;
        this.charset = charset;
    }

    @Override
    public void write(int i) {
        byte[] b = new byte[]{(byte)i};
        this.write(b, 0, 1);
    }

    @Override
    public void write(byte[] b, int offset, int length) {
        int endPos = offset + length;
        while (offset < endPos) {
            block0 : switch (this.state) {
                case 0: {
                    int m;
                    int i;
                    for (i = offset; i < endPos; ++i) {
                        if (b[i] != 13 && b[i] != 10) continue;
                        this.state = 1;
                        break;
                    }
                    if ((m = this.maxLineLength - this.line.length()) > 0) {
                        if (this.charset == null) {
                            this.line.append(new String(b, offset, Math.min(m, i - offset)));
                        } else {
                            this.line.append(new String(b, offset, Math.min(m, i - offset), this.charset));
                        }
                    }
                    if (this.state == 1) {
                        this.appendLine();
                    }
                    offset = i + 1;
                    break;
                }
                case 1: {
                    while (offset < endPos) {
                        if (b[offset] != 13 && b[offset] != 10) {
                            this.state = 0;
                            break block0;
                        }
                        ++offset;
                    }
                    break;
                }
            }
        }
    }

    @Override
    public void close() {
        if (this.line.length() > 0) {
            this.appendLine();
        }
        if (this.lastLines.size() <= 5) {
            this.firstLines.addAll(this.lastLines);
            String[] lines = new String[this.firstLines.size()];
            this.firstLines.toArray(lines);
            this.displayMessage = new TextProtocolMessage(lines);
        } else {
            String[] fLines = new String[this.firstLines.size()];
            this.firstLines.toArray(fLines);
            String[] lLines = new String[this.lastLines.size()];
            this.lastLines.toArray(lLines);
            this.displayMessage = new TextProtocolMessage(fLines, lLines);
        }
    }

    protected String appendLine() {
        String currentLine = this.line.toString();
        if (this.firstLines.size() < 5) {
            this.firstLines.add(currentLine);
        } else {
            if (this.lastLines.size() > 5) {
                this.lastLines.removeFirst();
            }
            this.lastLines.add(currentLine);
        }
        this.line.setLength(0);
        return currentLine;
    }

    public TextProtocolMessage getDisplayMessage() {
        return this.displayMessage;
    }
}

