/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format;

import de.businesslogics.format.ptk2.DisplayMessage;
import java.util.Locale;
import java.util.ResourceBundle;

class BinaryProtocolMessage
implements DisplayMessage {
    private static final long serialVersionUID = 1L;
    private final byte[] firstBytes;
    private final byte[] lastBytes;
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    BinaryProtocolMessage(byte[] allBytes) {
        this(allBytes, null);
    }

    BinaryProtocolMessage(byte[] firstBytes, byte[] lastBytes) {
        this.firstBytes = firstBytes;
        this.lastBytes = lastBytes;
    }

    @Override
    public void appendText(Locale locale, StringBuilder text) {
        ResourceBundle b = ResourceBundle.getBundle("de.businesslogics.format.TextProtocolMessage", locale);
        text.append("    ");
        text.append(b.getString("SEP"));
        if (this.lastBytes != null) {
            text.append("\r\n");
            text.append("     ");
            text.append(b.getString("FIRST"));
        }
        this.appendBytes(this.firstBytes, text);
        if (this.lastBytes != null) {
            text.append("\r\n");
            text.append("\r\n");
            text.append("     ");
            text.append(b.getString("LAST"));
            this.appendBytes(this.lastBytes, text);
        }
        text.append("\r\n");
        text.append("    ");
        text.append(b.getString("SEP"));
        text.append("\r\n");
    }

    private void appendBytes(byte[] b, StringBuilder text) {
        int pos = 0;
        while (pos < b.length) {
            int i;
            text.append("\r\n");
            text.append("     ");
            int lineEnd = pos + 16;
            if (lineEnd > b.length) {
                lineEnd = b.length;
            }
            for (i = pos; i < lineEnd; ++i) {
                int c = b[i] & 0xFF;
                text.append(DIGITS[c >> 4]);
                text.append(DIGITS[c & 0xF]);
                text.append(' ');
            }
            for (i = pos + 16; i > lineEnd; --i) {
                text.append("   ");
            }
            text.append("  ");
            for (i = pos; i < lineEnd; ++i) {
                if (b[i] >= 32 && b[i] <= 126) {
                    text.append((char)(0xFF & b[i]));
                    continue;
                }
                text.append('.');
            }
            pos = lineEnd;
        }
    }
}

