/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format;

import de.businesslogics.util.PaymentUtils;
import de.businesslogics.util.StringUtils;
import de.businesslogics.validation.RegularExpressions;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class AddressData {
    private String department;
    private String subDepartment;
    private String streetName;
    private String buildingNumber;
    private String buildingName;
    private String floor;
    private String postBox;
    private String room;
    private String postCode;
    private String townName;
    private String townLocationName;
    private String districtName;
    private String countrySubDivision;
    private String country;
    private String countryOfResidence;
    private final List<String> addressLines = new ArrayList<String>();

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getSubDepartment() {
        return this.subDepartment;
    }

    public void setSubDepartment(String subDepartment) {
        this.subDepartment = subDepartment;
    }

    public String getStreetName() {
        return this.streetName;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
    }

    public String getBuildingNumber() {
        return this.buildingNumber;
    }

    public void setBuildingNumber(String buildingNumber) {
        this.buildingNumber = buildingNumber;
    }

    public String getBuildingName() {
        return this.buildingName;
    }

    public void setBuildingName(String buildingName) {
        this.buildingName = buildingName;
    }

    public String getFloor() {
        return this.floor;
    }

    public void setFloor(String floor) {
        this.floor = floor;
    }

    public String getPostBox() {
        return this.postBox;
    }

    public void setPostBox(String postBox) {
        this.postBox = postBox;
    }

    public String getRoom() {
        return this.room;
    }

    public void setRoom(String room) {
        this.room = room;
    }

    public String getPostCode() {
        return this.postCode;
    }

    public void setPostCode(String postCode) {
        this.postCode = postCode;
    }

    public String getTownName() {
        return this.townName;
    }

    public void setTownName(String townName) {
        this.townName = townName;
    }

    public String getTownLocationName() {
        return this.townLocationName;
    }

    public void setTownLocationName(String townLocationName) {
        this.townLocationName = townLocationName;
    }

    public String getDistrictName() {
        return this.districtName;
    }

    public void setDistrictName(String districtName) {
        this.districtName = districtName;
    }

    public String getCountrySubDivision() {
        return this.countrySubDivision;
    }

    public void setCountrySubDivision(String countrySubDivision) {
        this.countrySubDivision = countrySubDivision;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCountryOfResidence() {
        return this.countryOfResidence;
    }

    public void setCountryOfResidence(String countryOfResidence) {
        this.countryOfResidence = countryOfResidence;
    }

    public List<String> getAddressLines() {
        return this.addressLines;
    }

    public static boolean areEqual(AddressData address1, AddressData address2) {
        if (address1 == null || address1.isEmpty()) {
            return address2 == null || address2.isEmpty();
        }
        if (address2 == null || address2.isEmpty()) {
            return false;
        }
        if (StringUtils.valuesDiffer(address1.getDepartment(), address2.getDepartment())) {
            return false;
        }
        if (StringUtils.valuesDiffer(address1.getSubDepartment(), address2.getSubDepartment())) {
            return false;
        }
        if (StringUtils.valuesDiffer(address1.getStreetName(), address2.getStreetName())) {
            return false;
        }
        if (StringUtils.valuesDiffer(address1.getBuildingNumber(), address2.getBuildingNumber())) {
            return false;
        }
        if (StringUtils.valuesDiffer(address1.getBuildingName(), address2.getBuildingName())) {
            return false;
        }
        if (StringUtils.valuesDiffer(address1.getFloor(), address2.getFloor())) {
            return false;
        }
        if (StringUtils.valuesDiffer(address1.getPostBox(), address2.getPostBox())) {
            return false;
        }
        if (StringUtils.valuesDiffer(address1.getRoom(), address2.getRoom())) {
            return false;
        }
        if (StringUtils.valuesDiffer(address1.getPostCode(), address2.getPostCode())) {
            return false;
        }
        if (StringUtils.valuesDiffer(address1.getTownName(), address2.getTownName())) {
            return false;
        }
        if (StringUtils.valuesDiffer(address1.getTownLocationName(), address2.getTownLocationName())) {
            return false;
        }
        if (StringUtils.valuesDiffer(address1.getDistrictName(), address2.getDistrictName())) {
            return false;
        }
        if (StringUtils.valuesDiffer(address1.getCountrySubDivision(), address2.getCountrySubDivision())) {
            return false;
        }
        if (StringUtils.valuesDiffer(address1.getCountry(), address2.getCountry())) {
            return false;
        }
        return !AddressData.addressLinesDiffer(address1.getAddressLines(), address2.getAddressLines());
    }

    private static boolean addressLinesDiffer(List<String> addressLines, List<String> originalAddressLines) {
        if (addressLines == null) {
            return originalAddressLines != null && originalAddressLines.size() > 0;
        }
        if (addressLines.size() == 0) {
            return originalAddressLines != null && originalAddressLines.size() > 0;
        }
        if (addressLines.size() != originalAddressLines.size()) {
            return true;
        }
        for (int i = 0; i < addressLines.size(); ++i) {
            if (!StringUtils.valuesDiffer(addressLines.get(i), originalAddressLines.get(i))) continue;
            return true;
        }
        return false;
    }

    public String getInformation(Locale locale) {
        StringBuilder sb = new StringBuilder();
        this.appendLine(this.department, sb);
        this.appendLine(this.subDepartment, sb);
        this.appendLine(this.townLocationName, sb);
        boolean hasStreetName = this.appendLine(this.streetName, sb);
        if (hasStreetName) {
            sb.append(' ');
            sb.append(StringUtils.checkNullAndTrim(this.buildingNumber));
        }
        this.appendLine(this.buildingName, sb);
        this.appendLine(this.floor, sb, "AddressData.floor", locale);
        this.appendLine(this.room, sb, "AddressData.room", locale);
        this.appendLine(this.postBox, sb, "AddressData.postBox", locale);
        boolean hasPostCode = this.appendLine(this.postCode, sb);
        if (hasPostCode) {
            sb.append(' ');
            sb.append(StringUtils.checkNullAndTrim(this.townName));
        } else {
            this.appendLine(this.townName, sb);
        }
        this.appendLine(this.districtName, sb);
        this.appendLine(this.countrySubDivision, sb);
        for (String addressline : this.addressLines) {
            this.appendLine(addressline, sb);
        }
        return sb.toString();
    }

    public String printInformation(Locale locale) {
        StringBuilder sb = new StringBuilder();
        sb.append("ADDRESS DATA");
        this.printField("Department", this.department, sb);
        this.printField("SubDepartment", this.subDepartment, sb);
        this.printField("StreetName", this.streetName, sb);
        this.printField("BuildingNumber", this.buildingNumber, sb);
        this.printField("BuildingName", this.buildingName, sb);
        this.printField("Floor", this.floor, sb);
        this.printField("PostBox", this.postBox, sb);
        this.printField("Room", this.room, sb);
        this.printField("PostCode", this.postCode, sb);
        this.printField("TownName", this.townName, sb);
        this.printField("TownLocationName", this.townLocationName, sb);
        this.printField("DistrictName", this.districtName, sb);
        this.printField("CountrySubDivision", this.countrySubDivision, sb);
        int i = 1;
        for (String addressline : this.addressLines) {
            if (StringUtils.checkNullAndTrim(addressline).length() <= 0) continue;
            this.printField("AddressLine " + i++, addressline, sb);
        }
        this.printField("Country", this.country, sb);
        sb.append('\n');
        sb.append("-------------------");
        return sb.toString();
    }

    private void printField(String name, String value, StringBuilder sb) {
        if (StringUtils.checkNullAndTrim(value).length() > 0) {
            this.appendLine(name + " = <" + value + ">", sb);
        }
    }

    public boolean isEmpty() {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.checkNullAndTrim(this.department));
        sb.append(StringUtils.checkNullAndTrim(this.subDepartment));
        sb.append(StringUtils.checkNullAndTrim(this.townLocationName));
        sb.append(StringUtils.checkNullAndTrim(this.streetName));
        sb.append(StringUtils.checkNullAndTrim(this.buildingNumber));
        sb.append(StringUtils.checkNullAndTrim(this.buildingName));
        sb.append(StringUtils.checkNullAndTrim(this.floor));
        sb.append(StringUtils.checkNullAndTrim(this.postBox));
        sb.append(StringUtils.checkNullAndTrim(this.room));
        sb.append(StringUtils.checkNullAndTrim(this.postCode));
        sb.append(StringUtils.checkNullAndTrim(this.townName));
        sb.append(StringUtils.checkNullAndTrim(this.districtName));
        sb.append(StringUtils.checkNullAndTrim(this.countrySubDivision));
        sb.append(StringUtils.checkNullAndTrim(this.country));
        for (String addressline : this.addressLines) {
            sb.append(StringUtils.checkNullAndTrim(addressline));
        }
        return sb.length() == 0;
    }

    public boolean isIncomplete() {
        if ((StringUtils.checkNullAndTrim(this.streetName).length() > 0 || StringUtils.checkNullAndTrim(this.postBox).length() > 0) && StringUtils.checkNullAndTrim(this.townName).length() > 0) {
            return false;
        }
        return this.addressLines.size() <= 0 || StringUtils.checkNullAndTrim(this.addressLines.get(0)).length() <= 0;
    }

    public boolean hasUnstructuredLines() {
        if (this.addressLines.size() > 0) {
            for (String addressLine : this.addressLines) {
                if (StringUtils.checkNullAndTrim(addressLine).length() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasStreetAndTown() {
        return StringUtils.checkNullAndTrim(this.streetName).length() > 0 && StringUtils.checkNullAndTrim(this.townName).length() > 0;
    }

    public boolean hasTown() {
        return StringUtils.checkNullAndTrim(this.townName).length() > 0;
    }

    private boolean appendLine(String s, StringBuilder sb) {
        return this.appendLine(s, sb, null, null);
    }

    private boolean appendLine(String s, StringBuilder sb, String bundleKey, Locale locale) {
        if ((s = StringUtils.checkNullAndTrim(s)).length() > 0) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            if (bundleKey != null) {
                sb.append(AddressData.getDescription(bundleKey, locale));
                sb.append(' ');
            }
            sb.append(s);
            return true;
        }
        return false;
    }

    public static AddressData replaceSEPAForeignChars(AddressData originalAddressData) {
        if (originalAddressData == null) {
            return null;
        }
        AddressData addressData = new AddressData();
        addressData.setCountry(originalAddressData.getCountry());
        addressData.setDepartment(PaymentUtils.getSEPAForeignStringForGUI(originalAddressData.department, 70));
        addressData.setSubDepartment(PaymentUtils.getSEPAForeignStringForGUI(originalAddressData.subDepartment, 70));
        addressData.setStreetName(PaymentUtils.getSEPAForeignStringForGUI(originalAddressData.streetName, 70));
        addressData.setBuildingNumber(PaymentUtils.getSEPAForeignStringForGUI(originalAddressData.buildingNumber, 16));
        addressData.setBuildingName(PaymentUtils.getSEPAForeignStringForGUI(originalAddressData.buildingName, 35));
        addressData.setFloor(PaymentUtils.getSEPAForeignStringForGUI(originalAddressData.floor, 70));
        addressData.setPostBox(PaymentUtils.getSEPAForeignStringForGUI(originalAddressData.postBox, 16));
        addressData.setRoom(PaymentUtils.getSEPAForeignStringForGUI(originalAddressData.room, 70));
        addressData.setPostCode(PaymentUtils.getSEPAForeignStringForGUI(originalAddressData.postCode, 16));
        addressData.setTownName(PaymentUtils.getSEPAForeignStringForGUI(originalAddressData.townName, 35));
        addressData.setTownLocationName(PaymentUtils.getSEPAForeignStringForGUI(originalAddressData.townLocationName, 35));
        addressData.setDistrictName(PaymentUtils.getSEPAForeignStringForGUI(originalAddressData.districtName, 35));
        addressData.setCountrySubDivision(PaymentUtils.getSEPAForeignStringForGUI(originalAddressData.countrySubDivision, 35));
        addressData.setCountryOfResidence(originalAddressData.countryOfResidence);
        for (int i = 0; i < originalAddressData.addressLines.size(); ++i) {
            addressData.getAddressLines().add(PaymentUtils.getSEPAForeignStringForGUI(originalAddressData.addressLines.get(i), 70));
        }
        return addressData;
    }

    public static String getDescription(String elementName, Locale locale) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("de.businesslogics.format.AddressData", locale);
            if (bundle == null) {
                bundle = ResourceBundle.getBundle("de.businesslogics.format.AddressData", Locale.getDefault());
            }
            return bundle.getString(elementName);
        }
        catch (Exception e) {
            return elementName;
        }
    }

    public static AddressData convertToDKSepaAddress(AddressData originalAddressData) {
        int countLines;
        String town;
        AddressData addressData = new AddressData();
        addressData.setCountry(originalAddressData.getCountry());
        String street = StringUtils.checkNullAndTrim(originalAddressData.getStreetName());
        if (street.length() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(street);
            String buildingNumber = StringUtils.checkNullAndTrim(originalAddressData.getBuildingNumber());
            if (buildingNumber.length() > 0) {
                sb.append(' ');
                sb.append(buildingNumber);
            }
            addressData.addressLines.add(sb.toString());
        }
        if ((town = StringUtils.checkNullAndTrim(originalAddressData.getTownName())).length() > 0) {
            StringBuilder sb = new StringBuilder();
            String postCode = StringUtils.checkNullAndTrim(originalAddressData.getPostCode());
            if (postCode.length() > 0) {
                sb.append(postCode);
                sb.append(' ');
            }
            sb.append(town);
            addressData.addressLines.add(sb.toString());
        }
        if ((countLines = addressData.addressLines.size()) >= 2) {
            return addressData;
        }
        return addressData;
    }

    public static AddressData getStructuredAddress(String street, String town, String countryCode) {
        if (!AddressData.isCountryCode(countryCode)) {
            return null;
        }
        AddressData address = null;
        if (!(street = StringUtils.checkNullAndTrim(street)).isEmpty()) {
            address = new AddressData();
            StringBuilder sbStreetName = new StringBuilder();
            StringBuilder sbBuildingNumber = new StringBuilder();
            AddressData.processLineWithStreet(street, sbStreetName, sbBuildingNumber);
            address.setStreetName(sbStreetName.toString());
            address.setBuildingNumber(sbBuildingNumber.toString());
        }
        if (!(town = StringUtils.checkNullAndTrim(town)).isEmpty()) {
            if (address == null) {
                address = new AddressData();
            }
            StringBuilder sbTownName = new StringBuilder();
            StringBuilder sbPostcode = new StringBuilder();
            AddressData.processLineWithTown(town, sbTownName, sbPostcode);
            address.setTownName(sbTownName.toString());
            address.setPostCode(sbPostcode.toString());
        }
        if (address != null) {
            address.setCountry(countryCode);
        }
        return address;
    }

    public static boolean isCountryCode(String countryCode) {
        return countryCode != null && RegularExpressions.COUNTRY_CODE.matches(countryCode);
    }

    protected static void processLineWithStreet(String addrLine, StringBuilder streetName, StringBuilder buidlingNumber) {
        StringTokenizer st = new StringTokenizer(addrLine);
        if (st.countTokens() == 1) {
            streetName.append(st.nextToken().trim());
        } else if (st.countTokens() > 1) {
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (buidlingNumber.length() == 0 && AddressData.isBuildingNumber(token)) {
                    AddressData.append(buidlingNumber, token);
                    continue;
                }
                AddressData.append(streetName, token);
            }
        }
    }

    protected static void processLineWithTown(String addrLine, StringBuilder townName, StringBuilder postcode) {
        StringTokenizer st = new StringTokenizer(addrLine, ",");
        if (st.countTokens() == 2) {
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (AddressData.containsInteger(token)) {
                    postcode.append(token);
                    continue;
                }
                townName.append(token);
            }
            return;
        }
        st = new StringTokenizer(addrLine);
        if (st.countTokens() == 1) {
            townName.append(st.nextToken().trim());
        } else if (st.countTokens() > 1) {
            String pendingToken = null;
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (AddressData.containsInteger(token)) {
                    if (pendingToken != null) {
                        AddressData.append(postcode, pendingToken);
                        pendingToken = null;
                    }
                    AddressData.append(postcode, token);
                    continue;
                }
                if (AddressData.hasUSStatePattern(token)) {
                    pendingToken = token;
                    continue;
                }
                AddressData.append(townName, token);
            }
        }
    }

    private static void append(StringBuilder sb, String s) {
        if (sb.length() > 0) {
            sb.append(" ");
        }
        sb.append(s);
    }

    private static boolean isBuildingNumber(String s) {
        return AddressData.containsInteger(s) && !s.matches("[\\d]*[\\.|st|ST|nd|ND|rd|RD|th|TH].*");
    }

    private static boolean containsInteger(String s) {
        return s.matches(".*\\d.*");
    }

    private static boolean hasUSStatePattern(String s) {
        return s.matches("[A-Z]{2,2}");
    }

    public static AddressData getUnstructuredAddress(String addrLine1, String addrLine2, String countryCode) {
        AddressData address = new AddressData();
        address.getAddressLines().add(addrLine1);
        address.getAddressLines().add(addrLine2);
        address.setCountry(countryCode);
        return address;
    }

    public static void main(String[] args) {
        String addrLine1 = "Telleringstra\u00c3\u009fe 11";
        String addrLine2 = "40721 Hilden";
        String country = "DE";
        AddressData address = AddressData.getUnstructuredAddress(addrLine1, addrLine2, country);
        System.out.println(address.printInformation(Locale.getDefault()));
        address = AddressData.getStructuredAddress(addrLine1, addrLine2, country);
        System.out.println(address.printInformation(Locale.getDefault()));
        addrLine1 = "12305 5th HELENA DR.";
        addrLine2 = "LOS ANGELES, CA 90049";
        country = "US";
        address = AddressData.getStructuredAddress(addrLine1, addrLine2, country);
        System.out.println(address.printInformation(Locale.getDefault()));
        addrLine1 = "Nove Mesto Platz 4b";
        addrLine2 = "40721 Hilden";
        country = "DE";
        address = AddressData.getStructuredAddress(addrLine1, addrLine2, country);
        System.out.println(address.printInformation(Locale.getDefault()));
    }
}

