/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.security;

import de.businesslogics.ebics.schema.types.SignatureVersion;
import de.businesslogics.ebics.security.EncryptionHandler;
import de.businesslogics.security.jce.Provider;
import de.businesslogics.security.jce.RIPEMD160_BCS;
import de.businesslogics.security.jce.SHA256_BCS;
import de.businesslogics.zkasecurity.A005PublicKey;
import de.businesslogics.zkasecurity.A006PublicKey;
import de.businesslogics.zkasecurity.RSAPrivateKey;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Calendar;
import java.util.TimeZone;
import javax.security.auth.x500.X500Principal;

public abstract class SignatureHandler {
    private static final SignatureHandler[] HANDLERS = new SignatureHandler[4];
    public static final SignatureHandler A004 = new A004SignatureHandler();
    public static final SignatureHandler A005 = new A005SignatureHandler();
    public static final SignatureHandler A006 = new A006SignatureHandler();
    public static final String ENDLESS_CERT_TIMEZONE_PROPERTY = "de.businesslogics.ebics.EndlessCertTimeZone";
    public static final long ENDLESS_CERT_EXPIRATION;
    private final int minKeyLength;
    private final int maxKeyLength;

    private SignatureHandler(int authenticationVersion, int minKeyLength, int maxKeyLength) {
        SignatureHandler.HANDLERS[authenticationVersion - 3] = this;
        this.minKeyLength = minKeyLength;
        this.maxKeyLength = maxKeyLength;
    }

    public int getMinKeyLength() {
        return this.minKeyLength;
    }

    public int getMaxKeyLength() {
        return this.maxKeyLength;
    }

    public static SignatureHandler getInstance(SignatureVersion version) {
        return HANDLERS[version.getVersion() - 3];
    }

    public static SignatureHandler getInstance(int version) {
        return HANDLERS[version - 3];
    }

    public abstract byte[] getHash(RSAPublicKey var1);

    public final byte[] getDigest(InputStream is) throws IOException {
        int i;
        MessageDigest md = this.getMessageDigest();
        byte[] buffer = new byte[4096];
        while ((i = is.read(buffer)) > 0) {
            md.update(buffer, 0, i);
        }
        is.close();
        return md.digest();
    }

    public abstract MessageDigest getMessageDigest();

    public final X509Certificate createSigSelfSignedCertificate(RSAPrivateKey privKey, X500Principal dn, boolean endlessCert) throws GeneralSecurityException {
        KeyPair p = new KeyPair(privKey.getPublicKey(), privKey.getPrivateKey());
        return this.createSigSelfSignedCertificate(p, dn, endlessCert);
    }

    public X509Certificate createSigSelfSignedCertificate(KeyPair keys, X500Principal dn, boolean endlessCert) throws GeneralSecurityException {
        return EncryptionHandler.createSelfSignedCertificate(keys, dn, endlessCert, 64);
    }

    static {
        String timezone = System.getProperty(ENDLESS_CERT_TIMEZONE_PROPERTY, null);
        if (timezone == null) {
            ENDLESS_CERT_EXPIRATION = 253402300799000L;
        } else {
            Calendar c = Calendar.getInstance(TimeZone.getTimeZone(timezone));
            c.clear();
            c.set(9999, 11, 31, 23, 59, 59);
            ENDLESS_CERT_EXPIRATION = c.getTimeInMillis();
        }
    }

    private static class A004SignatureHandler
    extends SignatureHandler {
        A004SignatureHandler() {
            super(4, 1024, 1024);
        }

        @Override
        public byte[] getHash(RSAPublicKey key) {
            return Provider.getRipeMdHash(key);
        }

        @Override
        public MessageDigest getMessageDigest() {
            return new RIPEMD160_BCS().getMessageDigest();
        }
    }

    private static class A005SignatureHandler
    extends SignatureHandler {
        A005SignatureHandler() {
            super(5, 1536, 16384);
        }

        @Override
        public byte[] getHash(RSAPublicKey key) {
            return A005PublicKey.getHash(key);
        }

        @Override
        public MessageDigest getMessageDigest() {
            return new SHA256_BCS().getMessageDigest();
        }
    }

    private static class A006SignatureHandler
    extends SignatureHandler {
        A006SignatureHandler() {
            super(6, 1536, 16384);
        }

        @Override
        public byte[] getHash(RSAPublicKey key) {
            return A006PublicKey.getHash(key);
        }

        @Override
        public MessageDigest getMessageDigest() {
            return new SHA256_BCS().getMessageDigest();
        }
    }
}

