/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.security;

import de.businesslogics.bouncycastle.asn1.ASN1Encodable;
import de.businesslogics.bouncycastle.asn1.x509.Extension;
import de.businesslogics.bouncycastle.asn1.x509.KeyUsage;
import de.businesslogics.bouncycastle.cert.bc.BcX509ExtensionUtils;
import de.businesslogics.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import de.businesslogics.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import de.businesslogics.bouncycastle.crypto.params.AsymmetricKeyParameter;
import de.businesslogics.bouncycastle.crypto.params.RSAKeyParameters;
import de.businesslogics.bouncycastle.operator.OperatorCreationException;
import de.businesslogics.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import de.businesslogics.ebics.client.CertificateAsKey;
import de.businesslogics.ebics.schema.Base64Element;
import de.businesslogics.ebics.schema.response.InvalidRequestContentException;
import de.businesslogics.ebics.schema.signature.X509Data;
import de.businesslogics.ebics.schema.types.EncryptionPubKeyDigest;
import de.businesslogics.ebics.schema.types.EncryptionVersion;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.security.SignatureHandler;
import de.businesslogics.zkasecurity.E001PrivateKey;
import de.businesslogics.zkasecurity.E001PublicKey;
import de.businesslogics.zkasecurity.E002PrivateKey;
import de.businesslogics.zkasecurity.E002PublicKey;
import de.businesslogics.zkasecurity.RSAPrivateKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.x500.X500Principal;

public abstract class EncryptionHandler {
    private static final EncryptionHandler[] HANDLERS = new EncryptionHandler[2];
    public static final EncryptionHandler E001 = new E001EncryptionHandler();
    public static final EncryptionHandler E002_H005 = new E002H005EncryptionHandler();
    public static final EncryptionHandler E002 = new E002EncryptionHandler();

    private EncryptionHandler(int encryptionVersion) {
        EncryptionHandler.HANDLERS[encryptionVersion - 1] = this;
    }

    public static EncryptionHandler getInstance(EncryptionVersion version) {
        return HANDLERS[version.getVersion() - 1];
    }

    public static EncryptionHandler getInstance(int version) {
        return HANDLERS[version - 1];
    }

    public static EncryptionHandler getInstance(ProtocolVersion version) {
        if (version.equals(ProtocolVersion.H002)) {
            return E001;
        }
        if (version.equals(ProtocolVersion.H005)) {
            return E002_H005;
        }
        return E002;
    }

    public abstract EncryptionVersion getVersion();

    public abstract byte[] getHash(RSAPublicKey var1);

    public abstract SecretKey createSecretKey();

    public abstract EncryptionPubKeyDigest createPubKeyDigest(byte[] var1);

    public abstract byte[] encrypt(RSAPublicKey var1, SecretKey var2);

    public abstract InputStream decryptContent(SecretKey var1, InputStream var2);

    public abstract OutputStream decryptContent(SecretKey var1, OutputStream var2);

    public abstract OutputStream encryptContent(SecretKey var1, OutputStream var2);

    public abstract SecretKeySpec getDecoded(byte[] var1);

    protected abstract void verifyDigest(EncryptionPubKeyDigest var1) throws InvalidRequestContentException;

    protected abstract String getDigestAlgorithm();

    public abstract long computeEncryptedSize(long var1);

    public boolean verifyDigest(EncryptionPubKeyDigest digest, byte[] myDigest) throws InvalidRequestContentException {
        this.verifyDigest(digest);
        if (digest.getValue() == null || digest.getValue().length == 0) {
            return true;
        }
        return Arrays.equals(digest.getValue(), myDigest);
    }

    public boolean verifyDigest(EncryptionPubKeyDigest digest, RSAPublicKey key) throws InvalidRequestContentException {
        this.verifyDigest(digest);
        if (digest.getValue() == null || digest.getValue().length == 0) {
            return true;
        }
        return Arrays.equals(digest.getValue(), this.getHash(key));
    }

    public static X509Certificate createSelfSignedCertificate(RSAPrivateKey privKey, X500Principal dn, boolean endlessCert) throws GeneralSecurityException {
        KeyPair p = new KeyPair(privKey.getPublicKey(), privKey.getPrivateKey());
        return EncryptionHandler.createSelfSignedCertificate(p, dn, endlessCert);
    }

    public static X509Certificate createSelfSignedCertificate(KeyPair keys, X500Principal dn, boolean endlessCert) throws GeneralSecurityException {
        return EncryptionHandler.createSelfSignedCertificate(keys, dn, endlessCert, 40);
    }

    public static X509Certificate createSelfSignedCertificate(KeyPair keys, X500Principal dn, boolean endlessCert, int keyUsage) throws GeneralSecurityException {
        return EncryptionHandler.createCertificate(dn, keys, dn, (RSAPublicKey)keys.getPublic(), endlessCert, keyUsage);
    }

    public static X509Certificate createCertificate(X500Principal issuerDN, KeyPair issuer, X500Principal subjectDN, RSAPublicKey subject, boolean endlessCert, int keyUsage) throws GeneralSecurityException {
        Date expiryDate;
        Calendar c = Calendar.getInstance();
        c.add(5, -1);
        Date startDate = c.getTime();
        if (endlessCert) {
            expiryDate = new Date(SignatureHandler.ENDLESS_CERT_EXPIRATION);
        } else {
            c.add(1, 5);
            expiryDate = c.getTime();
        }
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(issuerDN, BigInteger.valueOf(System.currentTimeMillis()), startDate, expiryDate, subjectDN, (PublicKey)subject);
        try {
            RSAPublicKey issuerPubKey = (RSAPublicKey)issuer.getPublic();
            RSAKeyParameters keySpec = new RSAKeyParameters(false, issuerPubKey.getModulus(), issuerPubKey.getPublicExponent());
            BcX509ExtensionUtils utils = new BcX509ExtensionUtils();
            builder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)utils.createAuthorityKeyIdentifier((AsymmetricKeyParameter)keySpec));
            keySpec = new RSAKeyParameters(false, subject.getModulus(), subject.getPublicExponent());
            builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)utils.createSubjectKeyIdentifier((AsymmetricKeyParameter)keySpec));
            builder.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(keyUsage));
            JcaContentSignerBuilder csb = new JcaContentSignerBuilder("SHA256withRSA");
            return new JcaX509CertificateConverter().getCertificate(builder.build(csb.build(issuer.getPrivate())));
        }
        catch (OperatorCreationException | IOException e) {
            throw new GeneralSecurityException(e);
        }
    }

    public byte[] getCertDigest(byte[] encrCert) {
        try {
            MessageDigest md = MessageDigest.getInstance(this.getDigestAlgorithm());
            assert (encrCert[0] == 48) : "Invalid certificate";
            int len = encrCert[1] & 0xFF;
            if (len < 128) {
                len += 2;
            } else {
                int i = len & 0x7F;
                len = 0;
                for (int j = 0; j < i; ++j) {
                    len = (len << 8) + (encrCert[j + 2] & 0xFF);
                }
                len += 2 + i;
            }
            md.update(encrCert, 0, len);
            return md.digest();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(nsae);
        }
    }

    public byte[] getCertDigest(X509Data x509Data) {
        if (x509Data == null) {
            return null;
        }
        List<X509Data.Choice> list = x509Data.getChoices();
        if (list != null) {
            for (X509Data.Choice choice : list) {
                Base64Element b = choice.getX509Certificate();
                if (b == null) continue;
                return this.getCertDigest(b.getValue());
            }
        }
        return null;
    }

    private static class E001EncryptionHandler
    extends EncryptionHandler {
        E001EncryptionHandler() {
            super(1);
        }

        @Override
        public EncryptionVersion getVersion() {
            return EncryptionVersion.E001;
        }

        @Override
        protected String getDigestAlgorithm() {
            return "SHA-1";
        }

        @Override
        public byte[] getHash(RSAPublicKey key) {
            return E001PublicKey.getHash(key);
        }

        @Override
        public SecretKey createSecretKey() {
            return E001PublicKey.createSecretKey();
        }

        @Override
        public EncryptionPubKeyDigest createPubKeyDigest(byte[] digest) {
            return new EncryptionPubKeyDigest(digest, "http://www.w3.org/2000/09/xmldsig#sha1", EncryptionVersion.E001);
        }

        @Override
        public byte[] encrypt(RSAPublicKey pubKey, SecretKey key) {
            return E001PublicKey.encrypt(pubKey, key.getEncoded());
        }

        @Override
        public InputStream decryptContent(SecretKey key, InputStream src) {
            return E001PrivateKey.decryptData(key, src);
        }

        @Override
        public OutputStream decryptContent(SecretKey key, OutputStream dest) {
            return E001PrivateKey.decryptData(key, dest);
        }

        @Override
        public OutputStream encryptContent(SecretKey key, OutputStream dest) {
            return E001PublicKey.encryptData(key, dest);
        }

        @Override
        public SecretKeySpec getDecoded(byte[] encoded) {
            if (encoded.length < 16) {
                byte[] tmp = new byte[16];
                Arrays.fill(tmp, 0, 16 - encoded.length, (byte)0);
                System.arraycopy(encoded, 0, tmp, 16 - encoded.length, encoded.length);
                encoded = tmp;
            }
            return new SecretKeySpec(encoded, "DESede");
        }

        @Override
        public void verifyDigest(EncryptionPubKeyDigest digest) throws InvalidRequestContentException {
            if (!EncryptionVersion.E001.equals(digest.getVersion()) || !"http://www.w3.org/2000/09/xmldsig#sha1".equals(digest.getAlgorithm())) {
                throw new InvalidRequestContentException();
            }
        }

        @Override
        public long computeEncryptedSize(long in) {
            return (in / 8L + 1L) * 8L;
        }
    }

    private static class E002H005EncryptionHandler
    extends E002EncryptionHandler {
        private E002H005EncryptionHandler() {
        }

        @Override
        public byte[] getHash(RSAPublicKey key) {
            if (!(key instanceof CertificateAsKey)) {
                return super.getHash(key);
            }
            return this.getCertDigest(((CertificateAsKey)key).getCertificate());
        }
    }

    private static class E002EncryptionHandler
    extends EncryptionHandler {
        E002EncryptionHandler() {
            super(2);
        }

        @Override
        public EncryptionVersion getVersion() {
            return EncryptionVersion.E002;
        }

        @Override
        protected String getDigestAlgorithm() {
            return "SHA-256";
        }

        @Override
        public byte[] getHash(RSAPublicKey key) {
            return E002PublicKey.getHash(key);
        }

        @Override
        public SecretKey createSecretKey() {
            return E002PublicKey.createSecretKey();
        }

        @Override
        public EncryptionPubKeyDigest createPubKeyDigest(byte[] digest) {
            return new EncryptionPubKeyDigest(digest, "http://www.w3.org/2001/04/xmlenc#sha256", EncryptionVersion.E002);
        }

        @Override
        public byte[] encrypt(RSAPublicKey pubKey, SecretKey key) {
            return E002PublicKey.encrypt(pubKey, key.getEncoded());
        }

        @Override
        public InputStream decryptContent(SecretKey key, InputStream src) {
            return E002PrivateKey.decryptData(key, src);
        }

        @Override
        public OutputStream decryptContent(SecretKey key, OutputStream dest) {
            return E002PrivateKey.decryptData(key, dest);
        }

        @Override
        public OutputStream encryptContent(SecretKey key, OutputStream dest) {
            return E002PublicKey.encryptData(key, dest);
        }

        @Override
        public SecretKeySpec getDecoded(byte[] encoded) {
            if (encoded.length < 16) {
                byte[] tmp = new byte[16];
                Arrays.fill(tmp, 0, 16 - encoded.length, (byte)0);
                System.arraycopy(encoded, 0, tmp, 16 - encoded.length, encoded.length);
                encoded = tmp;
            }
            return new SecretKeySpec(encoded, "AES");
        }

        @Override
        public void verifyDigest(EncryptionPubKeyDigest digest) throws InvalidRequestContentException {
            if (!EncryptionVersion.E002.equals(digest.getVersion()) || !"http://www.w3.org/2001/04/xmlenc#sha256".equals(digest.getAlgorithm())) {
                throw new InvalidRequestContentException();
            }
        }

        @Override
        public long computeEncryptedSize(long in) {
            return (in / 16L + 1L) * 16L;
        }
    }
}

