/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.security;

import de.businesslogics.ebics.client.CertificateAsKey;
import de.businesslogics.ebics.schema.types.AuthenticationPubKeyDigest;
import de.businesslogics.ebics.schema.types.AuthenticationVersion;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.security.EncryptionHandler;
import de.businesslogics.zkasecurity.RSAPrivateKey;
import de.businesslogics.zkasecurity.X001PublicKey;
import de.businesslogics.zkasecurity.X002PublicKey;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import javax.security.auth.x500.X500Principal;

public abstract class AuthenticationHandler {
    private static final AuthenticationHandler[] HANDLERS = new AuthenticationHandler[2];
    public static final AuthenticationHandler X001 = new X001AuthenticationHandler();
    public static final AuthenticationHandler X002_H005 = new X002H005AuthenticationHandler();
    public static final AuthenticationHandler X002 = new X002AuthenticationHandler();

    private AuthenticationHandler(int authenticationVersion) {
        AuthenticationHandler.HANDLERS[authenticationVersion - 1] = this;
    }

    public static AuthenticationHandler getInstance(AuthenticationVersion version) {
        return HANDLERS[version.getVersion() - 1];
    }

    public static AuthenticationHandler getInstance(int version) {
        return HANDLERS[version - 1];
    }

    public static AuthenticationHandler getInstance(ProtocolVersion version) {
        if (version.equals(ProtocolVersion.H002)) {
            return X001;
        }
        if (version.equals(ProtocolVersion.H005)) {
            return X002_H005;
        }
        return X002;
    }

    public static X509Certificate createSelfSignedCertificate(RSAPrivateKey privKey, X500Principal dn, boolean endlessCert) throws GeneralSecurityException {
        KeyPair p = new KeyPair(privKey.getPublicKey(), privKey.getPrivateKey());
        return AuthenticationHandler.createSelfSignedCertificate(p, dn, endlessCert);
    }

    public static X509Certificate createSelfSignedCertificate(KeyPair keys, X500Principal dn, boolean endlessCert) throws GeneralSecurityException {
        return EncryptionHandler.createSelfSignedCertificate(keys, dn, endlessCert, 128);
    }

    public byte[] getCertDigest(byte[] encrCert) {
        try {
            MessageDigest md = MessageDigest.getInstance(this.getDigestAlgorithm());
            assert (encrCert[0] == 48) : "Invalid certificate";
            int len = encrCert[1] & 0xFF;
            if (len < 128) {
                len += 2;
            } else {
                int i = len & 0x7F;
                len = 0;
                for (int j = 0; j < i; ++j) {
                    len = (len << 8) + (encrCert[j + 2] & 0xFF);
                }
                len += 2 + i;
            }
            md.update(encrCert, 0, len);
            return md.digest();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(nsae);
        }
    }

    public abstract AuthenticationVersion getVersion();

    public abstract byte[] getHash(RSAPublicKey var1);

    public abstract AuthenticationPubKeyDigest createPubKeyDigest(byte[] var1);

    protected abstract String getDigestAlgorithm();

    private static class X001AuthenticationHandler
    extends AuthenticationHandler {
        X001AuthenticationHandler() {
            super(1);
        }

        @Override
        public AuthenticationVersion getVersion() {
            return AuthenticationVersion.X001;
        }

        @Override
        protected String getDigestAlgorithm() {
            return "SHA-1";
        }

        @Override
        public byte[] getHash(RSAPublicKey key) {
            return X001PublicKey.getHash(key);
        }

        @Override
        public AuthenticationPubKeyDigest createPubKeyDigest(byte[] digest) {
            return new AuthenticationPubKeyDigest(digest, "http://www.w3.org/2000/09/xmldsig#sha1", AuthenticationVersion.X001);
        }
    }

    private static class X002H005AuthenticationHandler
    extends X002AuthenticationHandler {
        private X002H005AuthenticationHandler() {
        }

        @Override
        public byte[] getHash(RSAPublicKey key) {
            if (!(key instanceof CertificateAsKey)) {
                return super.getHash(key);
            }
            return this.getCertDigest(((CertificateAsKey)key).getCertificate());
        }
    }

    private static class X002AuthenticationHandler
    extends AuthenticationHandler {
        X002AuthenticationHandler() {
            super(2);
        }

        @Override
        public AuthenticationVersion getVersion() {
            return AuthenticationVersion.X002;
        }

        @Override
        protected String getDigestAlgorithm() {
            return "SHA-256";
        }

        @Override
        public byte[] getHash(RSAPublicKey key) {
            return X002PublicKey.getHash(key);
        }

        @Override
        public AuthenticationPubKeyDigest createPubKeyDigest(byte[] digest) {
            return new AuthenticationPubKeyDigest(digest, "http://www.w3.org/2001/04/xmlenc#sha256", AuthenticationVersion.X002);
        }
    }
}

