/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.types;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.SimpleStringElement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.xml.sax.SAXException;

public class TimeStamp
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private Date date;
    private TimeZone timeZone;

    public TimeStamp() {
        this(new Date());
    }

    public TimeStamp(Date d) {
        this.date = d;
        this.timeZone = TimeZone.getTimeZone("UTC");
    }

    public Date getDate() {
        return this.date;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public static void printOut(Date date, String elementName, EbicsPrintStream ps) {
        ps.openElement(elementName);
        ps.closeTag();
        ps.print(TimeStamp.toString(date));
        ps.closeElement();
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        if (this.timeZone != null) {
            sdf.setTimeZone(this.timeZone);
        } else {
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        Object s = sdf.format(this.date);
        if (this.timeZone != null) {
            int offset = (this.timeZone.getOffset(this.date.getTime()) + 30000) / 60000;
            if (offset == 0) {
                s = (String)s + "Z";
            } else {
                if (offset < 0) {
                    s = (String)s + "-";
                    offset = -offset;
                } else {
                    s = (String)s + "+";
                }
                s = (String)s + String.format("%02d:%02d", offset / 60, offset % 60);
            }
        } else {
            s = (String)s + "Z";
        }
        ps.print((String)s);
    }

    public void setFromString(String s) throws ParseException {
        this.setFromString(s, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setFromString(String s, boolean strict) throws ParseException {
        int l = ((String)s).length();
        int m = 0;
        if (l > 20 && ((String)s).charAt(19) == '.') {
            int j;
            int factor = 100;
            for (j = 20; j < l && ((String)s).charAt(j) >= '0' && ((String)s).charAt(j) <= '9'; ++j) {
                m += factor * (((String)s).charAt(j) - 48);
                factor /= 10;
            }
            s = ((String)s).substring(0, 19) + ((String)s).substring(j);
            l = ((String)s).length();
        }
        if (l > 19) {
            if (((String)s).charAt(l - 1) == 'Z') {
                this.timeZone = TimeZone.getTimeZone("UTC");
                s = ((String)s).substring(0, l - 1);
            } else {
                if (((String)s).charAt(l - 6) != '+' && ((String)s).charAt(l - 6) != '-') throw new ParseException("Timezone expected", l - 6);
                this.timeZone = TimeZone.getTimeZone("GMT" + ((String)s).substring(l - 6));
                s = ((String)s).substring(0, l - 6);
            }
        } else {
            this.timeZone = null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        if (this.timeZone != null) {
            sdf.setTimeZone(this.timeZone);
        }
        sdf.setLenient(!strict || ((String)s).endsWith("24:00:00"));
        this.date = sdf.parse((String)s);
        if (m <= 0) return;
        this.date = new Date((long)m + this.date.getTime());
    }

    public static Date fromString(String d) throws ParseException {
        return TimeStamp.fromString(d, false);
    }

    public static Date fromString(String d, boolean strict) throws ParseException {
        TimeStamp ts = new TimeStamp();
        ts.setFromString(d, strict);
        return ts.getDate();
    }

    public static String toString(Date d) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(d);
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        SimpleStringElement.Parser p = (SimpleStringElement.Parser)parser;
        String s = p.getCondensed();
        try {
            this.setFromString(s);
        }
        catch (ParseException pe) {
            SAXException se = new SAXException("Illegal date: " + s);
            se.initCause(pe);
            throw se;
        }
    }

    @Override
    public ElementParser createParser() {
        return new Parser(this);
    }

    private static class Parser
    extends SimpleStringElement.Parser {
        private final TimeStamp toReturn;

        private Parser(TimeStamp toReturn) {
            this.toReturn = toReturn;
        }

        @Override
        protected EbicsElement endElement() throws SAXException {
            this.toReturn.endElement(this);
            return this.toReturn;
        }

        @Override
        protected void setAttributes(EbicsAttributes attributes) throws SAXException {
            this.toReturn.setAttributes(attributes);
        }
    }
}

