/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.types;

import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.SimpleStringElement;
import java.util.regex.Pattern;
import org.xml.sax.SAXException;

public class SignatureVersion
extends SimpleStringElement {
    private static final long serialVersionUID = 1L;
    private static final Pattern PATTERN = Pattern.compile("A\\d{3}");
    public static final SignatureVersion A004 = new SignatureVersion();
    public static final SignatureVersion A005 = new SignatureVersion();
    public static final SignatureVersion A006 = new SignatureVersion();
    private static final SignatureVersion[] VERSIONS = new SignatureVersion[]{A004, A005, A006};

    public SignatureVersion() {
    }

    public SignatureVersion(String value) throws SAXException {
        super(value);
        if (!PATTERN.matcher(value).matches()) {
            throw new SAXException("Illegal value '" + value + " for signature version.");
        }
    }

    @Override
    public ElementParser createParser() {
        if (this == A004) {
            throw new IllegalStateException();
        }
        return super.createParser();
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        this.value = ((SimpleStringElement.Parser)parser).getCondensed();
        parser.checkPattern(this.value, PATTERN);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SignatureVersion)) {
            return false;
        }
        return this.value.equals(((SignatureVersion)obj).value);
    }

    @Override
    public final int hashCode() {
        return this.value.hashCode();
    }

    public short getVersion() {
        return Short.parseShort(this.value.substring(1));
    }

    public static SignatureVersion getInstance(int i) {
        if (i < 0 || i > 999) {
            throw new IllegalArgumentException(Integer.toString(i));
        }
        if (i < 4 || i > 6) {
            SignatureVersion toReturn = new SignatureVersion();
            toReturn.value = Integer.toString(i);
            while (toReturn.value.length() < 3) {
                toReturn.value = "0" + toReturn.value;
            }
            toReturn.value = "A" + String.valueOf(toReturn);
            return toReturn;
        }
        return VERSIONS[i - 4];
    }

    public static SignatureVersion getInstance(String version) {
        if (version == null) {
            return null;
        }
        if ("A004".equals(version)) {
            return A004;
        }
        if ("A005".equals(version)) {
            return A005;
        }
        if ("A006".equals(version)) {
            return A006;
        }
        SignatureVersion v = new SignatureVersion();
        v.value = version;
        return v;
    }

    static {
        SignatureVersion.A004.value = "A004";
        SignatureVersion.A005.value = "A005";
        SignatureVersion.A006.value = "A006";
    }
}

