/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.types;

import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.ebics.schema.response.AuthenticationFailedException;
import de.businesslogics.ebics.schema.response.BankPubKeyUpdateRequiredException;
import de.businesslogics.ebics.schema.response.EbicsException;
import de.businesslogics.ebics.schema.response.InternalErrorException;
import de.businesslogics.ebics.schema.response.InvalidOrderTypeException;
import de.businesslogics.ebics.schema.response.InvalidRequestContentException;
import de.businesslogics.ebics.schema.response.InvalidRequestException;
import de.businesslogics.ebics.schema.response.InvalidUserOrStateException;
import de.businesslogics.ebics.schema.response.MessageReplayException;
import de.businesslogics.ebics.schema.response.PartnerIDMismatchException;
import de.businesslogics.ebics.schema.response.SegmentNumberExceededException;
import de.businesslogics.ebics.schema.response.TransactionAbortedException;
import de.businesslogics.ebics.schema.response.UnknownHostIdException;
import de.businesslogics.ebics.schema.response.UnknownTransactionIdException;
import de.businesslogics.ebics.schema.response.UnsupportedOrderTypeException;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.ReportText;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.xml.sax.SAXException;

public class ReturnCode
extends SimpleStringElement
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private static final Map<ReturnCode, String> SYMBOLIC_NAMES = new HashMap<ReturnCode, String>();
    private static final Map<ReturnCode, ReturnCode> ALL_INSTANCES = new ConcurrentHashMap<ReturnCode, ReturnCode>();
    private static final int PV_MIN = ProtocolVersion.H002.getVersion();
    private static final int PV_MAX = ProtocolVersion.H005.getVersion();
    public static final ReturnCode EBICS_OK = new ReturnCode("000000", "EBICS_OK", null, null);
    public static final ReturnCode EBICS_DOWNLOAD_POSTPROCESS_DONE = new ReturnCode("011000", "EBICS_DOWNLOAD_POSTPROCESS_DONE", null, null);
    public static final ReturnCode EBICS_DOWNLOAD_POSTPROCESS_SKIPPED = new ReturnCode("011001", "EBICS_DOWNLOAD_POSTPROCESS_SKIPPED", null, null);
    public static final ReturnCode EBICS_TX_SEGMENT_NUMBER_UNDERRUN = new ReturnCode("011101", "EBICS_TX_SEGMENT_NUMBER_UNDERRUN", null, null);
    public static final ReturnCode EBICS_ORDER_PARAMS_IGNORED = new ReturnCode("031001", "EBICS_ORDER_PARAMS_IGNORED", null, null);
    public static final ReturnCode EBICS_AUTHENTICATION_FAILED = new ReturnCode("061001", "EBICS_AUTHENTICATION_FAILED", null, null);
    public static final ReturnCode EBICS_INVALID_REQUEST = new ReturnCode("061002", "EBICS_INVALID_REQUEST", null, null);
    public static final ReturnCode EBICS_INTERNAL_ERROR = new ReturnCode("061099", "EBICS_INTERNAL_ERROR", null, null);
    public static final ReturnCode EBICS_TX_RECOVERY_SYNC = new ReturnCode("061101", "EBICS_TX_RECOVERY_SYNC", null, null);
    public static final ReturnCode EBICS_INVALID_USER_OR_USER_STATE = new ReturnCode("091002", "EBICS_INVALID_USER_OR_USER_STATE", null, null);
    public static final ReturnCode EBICS_USER_UNKNOWN = new ReturnCode("091003", "EBICS_USER_UNKNOWN", null, null);
    public static final ReturnCode EBICS_INVALID_USER_STATE = new ReturnCode("091004", "EBICS_INVALID_USER_STATE", null, null);
    public static final ReturnCode EBICS_INVALID_ORDER_TYPE = new ReturnCode("091005", "EBICS_INVALID_ORDER_TYPE", ProtocolVersion.H003, ProtocolVersion.H004);
    public static final ReturnCode EBICS_INVALID_ORDER_IDENTIFIER = new ReturnCode("091005", "EBICS_INVALID_ORDER_IDENTIFIER", ProtocolVersion.H005, null);
    public static final ReturnCode EBICS_UNSUPPORTED_ORDER_TYPE = new ReturnCode("091006", "EBICS_UNSUPPORTED_ORDER_TYPE", ProtocolVersion.H003, ProtocolVersion.H004);
    public static final ReturnCode EBICS_UNSUPPORTED_ORDER_IDENTIFIER = new ReturnCode("091006", "EBICS_UNSUPPORTED_ORDER_IDENTIFIER", ProtocolVersion.H005, null);
    public static final ReturnCode EBICS_DISTRIBUTED_SIGNATURE_AUTHORISATION_FAILED = new ReturnCode("091007", "EBICS_DISTRIBUTED_SIGNATURE_AUTHORISATION_FAILED", null, null);
    public static final ReturnCode EBICS_BANK_PUBKEY_UPDATE_REQUIRED = new ReturnCode("091008", "EBICS_BANK_PUBKEY_UPDATE_REQUIRED", null, null);
    public static final ReturnCode EBICS_SEGMENT_SIZE_EXCEEDED = new ReturnCode("091009", "EBICS_SEGMENT_SIZE_EXCEEDED", null, null);
    public static final ReturnCode EBICS_INVALID_XML = new ReturnCode("091010", "EBICS_INVALID_XML", null, null);
    public static final ReturnCode EBICS_INVALID_HOSTID = new ReturnCode("091011", "EBICS_INVALID_HOSTID", null, null);
    public static final ReturnCode EBICS_TX_UNKNOWN_TXID = new ReturnCode("091101", "EBICS_TX_UNKNOWN_TXID", null, null);
    public static final ReturnCode EBICS_TX_ABORT = new ReturnCode("091102", "EBICS_TX_ABORT", null, null);
    public static final ReturnCode EBICS_TX_MESSAGE_REPLAY = new ReturnCode("091103", "EBICS_TX_MESSAGE_REPLAY", null, null);
    public static final ReturnCode EBICS_TX_SEGMENT_NUMBER_EXCEEDED = new ReturnCode("091104", "EBICS_TX_SEGMENT_NUMBER_EXCEEDED", null, null);
    public static final ReturnCode EBICS_INVALID_ORDER_PARAMS = new ReturnCode("091112", "EBICS_INVALID_ORDER_PARAMS", null, null);
    public static final ReturnCode EBICS_INVALID_REQUEST_CONTENT = new ReturnCode("091113", "EBICS_INVALID_REQUEST_CONTENT", null, null);
    public static final ReturnCode EBICS_MAX_ORDER_DATA_SIZE_EXCEEDED = new ReturnCode("091117", "EBICS_MAX_ORDER_DATA_SIZE_EXCEEDED", null, null);
    public static final ReturnCode EBICS_MAX_SEGMENTS_EXCEEDED = new ReturnCode("091118", "EBICS_MAX_SEGMENTS_EXCEEDED", null, null);
    public static final ReturnCode EBICS_MAX_TRANSACTIONS_EXCEEDED = new ReturnCode("091119", "EBICS_MAX_TRANSACTIONS_EXCEEDED", null, null);
    public static final ReturnCode EBICS_PARTNER_ID_MISMATCH = new ReturnCode("091120", "EBICS_PARTNER_ID_MISMATCH", null, null);
    public static final ReturnCode EBICS_INCOMPATIBLE_ORDER_ATTRIBUTE = new ReturnCode("091121", "EBICS_INCOMPATIBLE_ORDER_ATTRIBUTE", null, null);
    public static final ReturnCode EBICS_ORDER_ALREADY_EXISTS = new ReturnCode("091122", "EBICS_ORDER_ALREADY_EXISTS", null, null);
    int pvMask;

    public ReturnCode(ProtocolVersion pv) {
        this.pvMask = 1 << pv.getVersion();
    }

    ReturnCode(String value, ProtocolVersion minVersion, ProtocolVersion maxVersion) {
        super(value);
        int maxV = maxVersion == null ? PV_MAX : (int)maxVersion.getVersion();
        int mask = 0;
        for (int minV = minVersion == null ? PV_MIN : (int)minVersion.getVersion(); minV <= maxV; ++minV) {
            mask |= 1 << minV;
        }
        this.pvMask = mask;
        ALL_INSTANCES.put(this, this);
    }

    @Override
    public String name() {
        return "ReturnCode";
    }

    public void throwException(ReportText text) throws EbicsException {
        if (this.value.startsWith("00") || this.value.startsWith("01") || this.value.startsWith("03")) {
            return;
        }
        if (this.equals(EBICS_TX_RECOVERY_SYNC)) {
            return;
        }
        EbicsException toThrow = this.equals(EBICS_AUTHENTICATION_FAILED) ? new AuthenticationFailedException() : (this.equals(EBICS_BANK_PUBKEY_UPDATE_REQUIRED) ? new BankPubKeyUpdateRequiredException() : (this.equals(EBICS_INTERNAL_ERROR) ? new InternalErrorException("") : (this.equals(EBICS_INVALID_USER_OR_USER_STATE) ? new InvalidUserOrStateException() : (this.equals(EBICS_INVALID_REQUEST) ? new InvalidRequestException() : (this.equals(EBICS_INVALID_REQUEST_CONTENT) ? new InvalidRequestContentException() : (this.equals(EBICS_TX_MESSAGE_REPLAY) ? new MessageReplayException() : (this.equals(EBICS_TX_UNKNOWN_TXID) ? new UnknownTransactionIdException() : (this.equals(EBICS_TX_SEGMENT_NUMBER_EXCEEDED) ? new SegmentNumberExceededException() : (this.equals(EBICS_TX_ABORT) ? new TransactionAbortedException() : (this.equals(EBICS_INVALID_ORDER_TYPE) ? new InvalidOrderTypeException("") : (this.equals(EBICS_UNSUPPORTED_ORDER_TYPE) ? new UnsupportedOrderTypeException() : (this.equals(EBICS_PARTNER_ID_MISMATCH) ? new PartnerIDMismatchException() : (this.equals(EBICS_INVALID_HOSTID) ? new UnknownHostIdException() : new EbicsException(this))))))))))))));
        toThrow.setReportText(text.getValue());
        throw toThrow;
    }

    ReturnCode(String value, String key, ProtocolVersion minVersion, ProtocolVersion maxVersion) {
        this(value, minVersion, maxVersion);
        String s = SYMBOLIC_NAMES.put(this, key);
        if (s != null && !s.equals(key)) {
            throw new RuntimeException("Different key='" + key + "' added for value='" + value + "'");
        }
    }

    public String getSymbolicName() {
        return SYMBOLIC_NAMES.get(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        ReturnCode o = (ReturnCode)obj;
        return o.value.equals(this.value) && (o.pvMask & this.pvMask) != 0;
    }

    public ReturnCode getInstanceFor(ProtocolVersion pv) {
        if (pv == null) {
            return this;
        }
        int m = 1 << pv.getVersion();
        if ((this.pvMask & m) != 0) {
            return this;
        }
        ReturnCode toReturn = this.clone();
        toReturn.pvMask = m;
        return (toReturn = ALL_INSTANCES.get(toReturn)) == null ? this : toReturn;
    }

    protected ReturnCode clone() {
        try {
            return (ReturnCode)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("We are cloneable", e);
        }
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() ^ this.value.hashCode();
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        this.value = ((SimpleStringElement.Parser)parser).getCondensed();
        int i = 0;
        if (this.value.length() == 6) {
            while (i < 6 && Character.isDigit(this.value.charAt(i++))) {
            }
        }
        if (i != 6) {
            throw new SAXException("ReturnCode must be 6 digits");
        }
        ReturnCode standardCode = ALL_INSTANCES.get(this);
        if (standardCode != null) {
            this.pvMask = standardCode.pvMask;
        }
    }

    public String getText() {
        return this.getText(Locale.getDefault());
    }

    public String getText(Locale l) {
        ResourceBundle bundle = ResourceBundle.getBundle(ReportText.class.getName(), l);
        try {
            return bundle.getString(this.getBundleKey());
        }
        catch (MissingResourceException mr) {
            return "[" + this.getSymbolicName() + "] " + this.getValue();
        }
    }

    public static Collection<ReturnCode> getInstances() {
        return Collections.unmodifiableCollection(SYMBOLIC_NAMES.keySet());
    }

    protected String getBundleKey() {
        if (this.pvMask == ReturnCode.EBICS_OK.pvMask) {
            return this.value;
        }
        int minV = Integer.numberOfTrailingZeros(this.pvMask);
        int maxV = 31 - Integer.numberOfLeadingZeros(this.pvMask);
        StringBuilder toReturn = new StringBuilder(10).append(this.value).append('_');
        if (minV == maxV && minV != PV_MIN && minV != PV_MAX) {
            toReturn.append(minV);
        } else {
            if (minV > PV_MIN) {
                toReturn.append(minV);
            }
            toReturn.append('-');
            if (maxV < PV_MAX) {
                toReturn.append(maxV);
            }
        }
        return toReturn.toString();
    }
}

