/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.types;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.signature.RSAKeyValue;
import de.businesslogics.ebics.schema.types.TimeStamp;
import org.xml.sax.SAXException;

public class PubKeyValue
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private RSAKeyValue rsaKeyValue;
    private TimeStamp timeStamp;

    public PubKeyValue() {
    }

    public PubKeyValue(RSAKeyValue rsaKeyValue) {
        this.rsaKeyValue = rsaKeyValue;
    }

    public RSAKeyValue getRSAKeyValue() {
        return this.rsaKeyValue;
    }

    public TimeStamp getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(TimeStamp timeStamp) {
        this.timeStamp = timeStamp;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.rsaKeyValue.printOut("ds:RSAKeyValue", ps);
        ps.printOut("TimeStamp", this.timeStamp);
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (uri.equals("http://www.w3.org/2000/09/xmldsig#") && localName.equals("RSAKeyValue") && parser.allowChild(0)) {
            this.rsaKeyValue = new RSAKeyValue();
            return this.rsaKeyValue;
        }
        if (parser.isParentUri(uri) && localName.equals("TimeStamp") && parser.allowChild(1)) {
            this.timeStamp = new TimeStamp(null);
            return this.timeStamp;
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(0);
    }
}

