/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.types;

import de.businesslogics.ebics.client.CertificateAsKey;
import de.businesslogics.ebics.schema.AnyElement;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.response.InvalidOrderDataFormatException;
import de.businesslogics.ebics.schema.signature.X509Data;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.PubKeyValue;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

public abstract class PubKeyInfo
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private static final List<String> NAMESPACES_DONT_IGNORE = new ArrayList<String>(5);
    private PubKeyValue pubKeyValue;
    private X509Data x509Data;

    @Deprecated
    public PubKeyValue getPubKeyValue() {
        return this.pubKeyValue;
    }

    public void setPubKeyValue(PubKeyValue pubKeyValue) {
        this.pubKeyValue = pubKeyValue;
    }

    public X509Data getX509Data() {
        return this.x509Data;
    }

    public void setX509Data(X509Data data) {
        this.x509Data = data;
    }

    public RSAPublicKey getPublicKey() throws InvalidOrderDataFormatException {
        try {
            if (this.pubKeyValue != null) {
                return this.pubKeyValue.getRSAKeyValue().getPublicKey();
            }
            return new CertificateAsKey((byte[])this.getX509Data().getMainKey()[1]);
        }
        catch (IllegalArgumentException iae) {
            throw (InvalidOrderDataFormatException)new InvalidOrderDataFormatException().initCause(iae);
        }
    }

    @Override
    protected void printValue(EbicsPrintStream ps) {
        ps.printOut("ds:X509Data", this.x509Data);
        ps.printOut("PubKeyValue", this.pubKeyValue);
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String name) throws SAXException {
        if (uri.equals("http://www.w3.org/2000/09/xmldsig#") && "X509Data".equals(localName) && parser.allowChild(0)) {
            this.x509Data = new X509Data();
            return this.x509Data;
        }
        if (parser.isParentUri(uri) && PubKeyInfo.allowPubKeyValue(uri) && "PubKeyValue".equals(localName) && parser.allowChild(-1, 1)) {
            this.pubKeyValue = new PubKeyValue();
            return this.pubKeyValue;
        }
        if (!NAMESPACES_DONT_IGNORE.contains(uri) && parser.getCurrentChild() == (PubKeyInfo.allowPubKeyValue(parser.getParentUri()) ? 1 : 0)) {
            return AnyElement.INSTANCE;
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(PubKeyInfo.allowPubKeyValue(parser.getParentUri()) ? 1 : 0);
    }

    private static boolean allowPubKeyValue(String uri) {
        return uri.endsWith("H002") || uri.endsWith("H003") || uri.endsWith("H004") || uri.endsWith("S001");
    }

    static {
        NAMESPACES_DONT_IGNORE.add("http://www.ebics.org/S001");
        NAMESPACES_DONT_IGNORE.add("http://www.ebics.org/S002");
        NAMESPACES_DONT_IGNORE.add(ProtocolVersion.H002.getNamespace());
        NAMESPACES_DONT_IGNORE.add(ProtocolVersion.H003.getNamespace());
        NAMESPACES_DONT_IGNORE.add(ProtocolVersion.H004.getNamespace());
        NAMESPACES_DONT_IGNORE.add(ProtocolVersion.H005.getNamespace());
    }
}

