/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.types;

import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.ebics.schema.types.SignatureVersion;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.xml.sax.SAXParseException;

public class ProtocolVersion
extends SimpleStringElement
implements Comparable<ProtocolVersion> {
    private static final long serialVersionUID = 1L;
    private static final Pattern PATTERN = Pattern.compile("H\\d{3}");
    public static final ProtocolVersion H002 = new ProtocolVersion();
    public static final ProtocolVersion H003 = new ProtocolVersion();
    public static final ProtocolVersion H004 = new ProtocolVersion();
    public static final ProtocolVersion H005 = new ProtocolVersion();
    private static final Map<String, ProtocolVersion> NAMESPACE2PV = new HashMap<String, ProtocolVersion>(3);
    private static final String[] NAMESPACES = new String[]{"http://www.ebics.org/H002", "http://www.ebics.org/H003", "urn:org:ebics:H004", "urn:org:ebics:H005"};
    private static final String[] SCHEMA_LOCATIONS;

    public static ProtocolVersion getInstance(String version) {
        if (version.equals(ProtocolVersion.H002.value)) {
            return H002;
        }
        if (version.equals(ProtocolVersion.H003.value)) {
            return H003;
        }
        if (version.equals(ProtocolVersion.H004.value)) {
            return H004;
        }
        if (version.equals(ProtocolVersion.H005.value)) {
            return H005;
        }
        return new ProtocolVersion(version);
    }

    @Deprecated
    public ProtocolVersion() {
    }

    private ProtocolVersion(String value) {
        super(value);
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXParseException {
        SimpleStringElement.StringParser p = (SimpleStringElement.StringParser)parser;
        this.value = p.getCondensed();
        p.checkPattern(PATTERN);
    }

    public String getNamespace() {
        return NAMESPACES[this.getVersion() - 2];
    }

    public String getNamespaceSchemaLocation() {
        return SCHEMA_LOCATIONS[this.getVersion() - 2];
    }

    public short getVersion() {
        return Short.parseShort(this.value.substring(1));
    }

    public static ProtocolVersion fromNameSpace(String nameSpace) {
        return NAMESPACE2PV.get(nameSpace);
    }

    @Override
    public int compareTo(ProtocolVersion o) {
        return this.value.compareTo(o.value);
    }

    public int getMinimumSigKeyLength() {
        return this.compareTo(H004) <= 0 ? 1536 : 2048;
    }

    public int getMinimumProtKeyLength() {
        return this.compareTo(H004) <= 0 ? 1024 : 2048;
    }

    public boolean isAllowed(SignatureVersion signatureVersion) {
        return this.compareTo(H005) < 0 || signatureVersion.getVersion() >= 5;
    }

    static {
        ProtocolVersion.H002.value = "H002";
        ProtocolVersion.H003.value = "H003";
        ProtocolVersion.H004.value = "H004";
        ProtocolVersion.H005.value = "H005";
        NAMESPACE2PV.put(H002.getNamespace(), H002);
        NAMESPACE2PV.put(H003.getNamespace(), H003);
        NAMESPACE2PV.put(H004.getNamespace(), H004);
        NAMESPACE2PV.put(H005.getNamespace(), H005);
        SCHEMA_LOCATIONS = new String[]{H002.getNamespace() + " http://www.ebics.org/H002/ebics.xsd", H003.getNamespace() + " http://www.ebics.org/H003/ebics.xsd", H004.getNamespace() + " http://www.ebics.org/H004/ebics_H004.xsd", H005.getNamespace() + " http://www.ebics.org/H005/ebics_H005.xsd"};
    }
}

