/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.types;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.ebics.schema.Token;
import de.businesslogics.util.Objects;
import org.xml.sax.SAXException;

public class Parameter
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private Token name;
    private Value value;

    public Parameter() {
    }

    public Parameter(Token name, Value value) {
        this.name = name;
        this.value = value;
    }

    public Token getName() {
        return this.name;
    }

    public Value getValue() {
        return this.value;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.name.printOut("Name", ps);
        this.value.printOut("Value", ps);
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if (localName.equals("Name") && parser.allowChild(0)) {
                this.name = new Token();
                return this.name;
            }
            if (localName.equals("Value") && parser.allowChild(1)) {
                this.value = new Value();
                return this.value;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Parameter)) {
            return false;
        }
        Parameter other = (Parameter)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value);
    }

    public static class Value
    extends SimpleStringElement {
        public static final Value EMPTY = new Value("");
        private static final long serialVersionUID = 1L;
        private String type = "string";

        public Value() {
        }

        public Value(String value) {
            super(value);
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        @Override
        protected void addAttributes(EbicsPrintStream ps) {
            ps.addAttribute("Type", this.type, "string".equals(this.type));
        }

        @Override
        protected void setAttributes(EbicsAttributes attributes) throws SAXException {
            this.type = attributes.getValueWithDefault("Type", "string");
        }
    }
}

