/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.types;

import de.businesslogics.bcs.core.YYMMDD;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.SimpleStringElement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class GYearMonth
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private YYMMDD date;

    public GYearMonth() {
    }

    public GYearMonth(YYMMDD when) {
        this.date = when;
    }

    public YYMMDD getDate() {
        return this.date;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        ps.print(this.toString());
    }

    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        sdf.setTimeZone(this.date.getTimeZone());
        return sdf.format(this.date);
    }

    @Override
    public ElementParser createParser() {
        return new SimpleStringElement.StringParser(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static YYMMDD fromString(String s, Locator locator) throws SAXParseException {
        TimeZone tz;
        int l = s.length();
        if (l > 10) {
            if (s.charAt(l - 1) == 'Z') {
                tz = TimeZone.getTimeZone("UTC");
                s = s.substring(0, l - 1);
            } else {
                if (s.charAt(l - 6) != '+' && s.charAt(l - 6) != '-') throw new SAXParseException("Invalid timezone", locator);
                tz = TimeZone.getTimeZone("GMT" + s.substring(l - 6));
                s = s.substring(0, l - 6);
            }
        } else {
            tz = TimeZone.getDefault();
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        sdf.setTimeZone(tz);
        try {
            Date toReturn = sdf.parse(s);
            return new YYMMDD(toReturn.getTime(), tz);
        }
        catch (ParseException pe) {
            throw new SAXParseException("Invalid date", locator);
        }
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        this.date = GYearMonth.fromString(((SimpleStringElement.Parser)parser).getCondensed(), parser.getLocator());
    }
}

