/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.types;

import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.SimpleStringElement;
import java.util.regex.Pattern;
import org.xml.sax.SAXException;

public class EncryptionVersion
extends SimpleStringElement {
    private static final long serialVersionUID = 1L;
    private static final Pattern PATTERN = Pattern.compile("E\\d{3}");
    public static final EncryptionVersion E001 = new EncryptionVersion();
    public static final EncryptionVersion E002 = new EncryptionVersion();
    private static final EncryptionVersion[] VERSIONS = new EncryptionVersion[]{E001, E002};

    public EncryptionVersion() {
    }

    public EncryptionVersion(String value) throws SAXException {
        super(value);
        if (!PATTERN.matcher(value).matches()) {
            throw new SAXException("Illegal value '" + value + " for encryption version.");
        }
    }

    @Override
    public ElementParser createParser() {
        if (this == E001 || this == E002) {
            throw new IllegalStateException();
        }
        return super.createParser();
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        this.value = ((SimpleStringElement.Parser)parser).getCondensed();
        parser.checkPattern(this.value, PATTERN);
    }

    public short getVersion() {
        return Short.parseShort(this.value.substring(1));
    }

    public static EncryptionVersion getInstance(int i) {
        if (i < 0 || i > 999) {
            throw new IllegalArgumentException(Integer.toString(i));
        }
        if (i < 1 || i > 2) {
            EncryptionVersion toReturn = new EncryptionVersion();
            toReturn.value = Integer.toString(i);
            while (toReturn.value.length() < 3) {
                toReturn.value = "0" + toReturn.value;
            }
            return toReturn;
        }
        return VERSIONS[i - 1];
    }

    static {
        EncryptionVersion.E001.value = "E001";
        EncryptionVersion.E002.value = "E002";
    }
}

