/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.types;

import de.businesslogics.ebics.schema.Base64Element;
import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.types.EncryptionVersion;
import org.xml.sax.SAXException;

public class EncryptionPubKeyDigest
extends Base64Element {
    private static final long serialVersionUID = 1L;
    private String algorithm;
    private EncryptionVersion version;

    public EncryptionPubKeyDigest() {
    }

    public EncryptionPubKeyDigest(byte[] digest, String algorithm, EncryptionVersion version) {
        super(digest);
        this.algorithm = algorithm;
        this.version = version;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public EncryptionVersion getVersion() {
        return this.version;
    }

    @Override
    public void addAttributes(EbicsPrintStream ps) {
        ps.addAttribute("Algorithm", this.algorithm);
        ps.addAttribute("Version", this.version.getValue());
    }

    @Override
    protected void setAttributes(EbicsAttributes attributes) throws SAXException {
        this.algorithm = attributes.getMandatoryValue("Algorithm");
        this.version = new EncryptionVersion(attributes.getMandatoryValue("Version"));
    }
}

