/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.types;

import de.businesslogics.ebics.schema.Base64Element;
import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.types.EncryptionPubKeyDigest;
import org.xml.sax.SAXException;

public class DataEncryption
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private EncryptionPubKeyDigest encryptionPubKeyDigest;
    private Base64Element transactionKey;

    public DataEncryption() {
    }

    public DataEncryption(EncryptionPubKeyDigest encryptionPubKeyDigest, Base64Element transactionKey) {
        this.encryptionPubKeyDigest = encryptionPubKeyDigest;
        this.transactionKey = transactionKey;
    }

    @Override
    protected void addAttributes(EbicsPrintStream ps) {
        ps.addAttribute("authenticate", "true");
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.encryptionPubKeyDigest.printOut("EncryptionPubKeyDigest", ps);
        this.transactionKey.printOut("TransactionKey", ps);
    }

    public EncryptionPubKeyDigest getEncryptionPubKeyDigest() {
        return this.encryptionPubKeyDigest;
    }

    public Base64Element getTransactionKey() {
        return this.transactionKey;
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if (localName.equals("EncryptionPubKeyDigest") && parser.allowChild(0)) {
                this.encryptionPubKeyDigest = new EncryptionPubKeyDigest();
                return this.encryptionPubKeyDigest;
            }
            if (localName.equals("TransactionKey") && parser.allowChild(1)) {
                this.transactionKey = new Base64Element();
                return this.transactionKey;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(1);
    }

    @Override
    protected void setAttributes(EbicsAttributes attributes) throws SAXException {
        attributes.checkFixed("authenticate", "true");
    }
}

