/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.types;

import de.businesslogics.ebics.schema.Base64Element;
import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.SignatureVersion;
import org.xml.sax.SAXException;

public class DataDigest
extends Base64Element {
    private static final long serialVersionUID = 1L;
    private SignatureVersion signatureVersion;

    @Deprecated
    public DataDigest() {
    }

    public DataDigest(byte[] value, SignatureVersion signatureVersion) {
        super(value);
        this.signatureVersion = signatureVersion;
    }

    public SignatureVersion getSignatureVersion() {
        return this.signatureVersion;
    }

    @Override
    public void addAttributes(EbicsPrintStream ps) {
        if (!ps.getNamespaceURI("").equals(ProtocolVersion.H002.getNamespace())) {
            ps.addAttribute("SignatureVersion", this.signatureVersion.getValue(), !this.signatureVersion.equals(SignatureVersion.A004));
        }
    }

    @Override
    protected void setAttributes(EbicsAttributes attributes) throws SAXException {
        ProtocolVersion pv = ProtocolVersion.fromNameSpace(attributes.getParentUri());
        int version = 4;
        if (pv != null) {
            version = pv.getVersion();
        }
        if (version == 2) {
            this.signatureVersion = SignatureVersion.A004;
        } else {
            String s = version < 5 ? attributes.getValueWithDefault("SignatureVersion", "A004") : attributes.getMandatoryValue("SignatureVersion");
            this.signatureVersion = new SignatureVersion(s);
        }
    }
}

