/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.types;

import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.SimpleStringElement;
import java.util.regex.Pattern;
import org.xml.sax.SAXException;

public class AuthenticationVersion
extends SimpleStringElement {
    private static final long serialVersionUID = 1L;
    private static final Pattern PATTERN = Pattern.compile("X\\d{3}");
    public static final AuthenticationVersion X001 = new AuthenticationVersion();
    public static final AuthenticationVersion X002 = new AuthenticationVersion();
    private static final AuthenticationVersion[] VERSIONS = new AuthenticationVersion[]{X001, X002};

    public AuthenticationVersion() {
    }

    public AuthenticationVersion(String value) throws SAXException {
        super(value);
        if (!PATTERN.matcher(value).matches()) {
            throw new SAXException("Illegal value '" + value + "' for protocol version.");
        }
    }

    public short getVersion() {
        return Short.parseShort(this.value.substring(1));
    }

    @Override
    public ElementParser createParser() {
        if (this == X001 || this == X002) {
            throw new IllegalStateException("Called on constant object");
        }
        return super.createParser();
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        this.value = ((SimpleStringElement.Parser)parser).getCondensed();
        parser.checkPattern(this.value, PATTERN);
    }

    public static AuthenticationVersion getInstance(int i) {
        if (i < 0 || i > 999) {
            throw new IllegalArgumentException(Integer.toString(i));
        }
        if (i < 1 || i > 2) {
            AuthenticationVersion toReturn = new AuthenticationVersion();
            toReturn.value = Integer.toString(i);
            while (toReturn.value.length() < 3) {
                toReturn.value = "0" + toReturn.value;
            }
            return toReturn;
        }
        return VERSIONS[i - 1];
    }

    static {
        AuthenticationVersion.X001.value = "X001";
        AuthenticationVersion.X002.value = "X002";
    }
}

