/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.types;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.response.AuthorisationFailedException;
import de.businesslogics.ebics.schema.response.DuplicateSignatureException;
import de.businesslogics.ebics.schema.response.EbicsException;
import de.businesslogics.ebics.schema.response.InvalidOrderDataFormatException;
import de.businesslogics.ebics.schema.response.InvalidSignatureFileFormatException;
import de.businesslogics.ebics.schema.response.InvalidSignerStateException;
import de.businesslogics.ebics.schema.response.KeymgmtDuplicateKeyException;
import de.businesslogics.ebics.schema.response.KeymgmtNoX509SupportException;
import de.businesslogics.ebics.schema.response.NoDownloadDataAvailableException;
import de.businesslogics.ebics.schema.response.SignatureVerificationFailedException;
import de.businesslogics.ebics.schema.response.SignerUnknownException;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.ReturnCode;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.xml.sax.SAXException;

public class AuthenticatedReturnCode
extends ReturnCode {
    private static final long serialVersionUID = 1L;
    private static final HashMap<AuthenticatedReturnCode, String> SYMBOLIC_NAMES = new HashMap();
    public static final AuthenticatedReturnCode EBICS_OK = new AuthenticatedReturnCode("000000", "EBICS_OK", null, null);
    public static final AuthenticatedReturnCode EBICS_NO_ONLINE_CHECKS = new AuthenticatedReturnCode("011301", "EBICS_NO_ONLINE_CHECKS", null, null);
    public static final AuthenticatedReturnCode EBICS_DOWNLOAD_SIGNED_ONLY = new AuthenticatedReturnCode("091001", "EBICS_DOWNLOAD_SIGNED_ONLY", null, null);
    public static final AuthenticatedReturnCode EBICS_DOWNLOAD_UNSIGNED_ONLY = new AuthenticatedReturnCode("091002", "EBICS_DOWNLOAD_UNSIGNED_ONLY", null, null);
    public static final AuthenticatedReturnCode EBICS_AUTHORISATION_FAILED = new AuthenticatedReturnCode("090003", "EBICS_AUTHORISATION_FAILED", null, ProtocolVersion.H002);
    public static final AuthenticatedReturnCode EBICS_AUTHORISATION_ORDER_TYPE_FAILED = new AuthenticatedReturnCode("090003", "EBICS_AUTHORISATION_ORDER_TYPE_FAILED", ProtocolVersion.H003, ProtocolVersion.H004);
    public static final AuthenticatedReturnCode EBICS_AUTHORISATION_ORDER_IDENTIFIER_FAILED = new AuthenticatedReturnCode("090003", "EBICS_AUTHORISATION_ORDER_IDENTIFIER_FAILED", ProtocolVersion.H005, null);
    public static final AuthenticatedReturnCode EBICS_INVALID_ORDER_DATA_FORMAT = new AuthenticatedReturnCode("090004", "EBICS_INVALID_ORDER_DATA_FORMAT", null, null);
    public static final AuthenticatedReturnCode EBICS_NO_DOWNLOAD_DATA_AVAILABLE = new AuthenticatedReturnCode("090005", "EBICS_NO_DOWNLOAD_DATA_AVAILABLE", null, null);
    public static final AuthenticatedReturnCode EBICS_UNSUPPORTED_REQUEST_FOR_ORDER_INSTANCE = new AuthenticatedReturnCode("090006", "EBICS_UNSUPPORTED_REQUEST_FOR_ORDER_INSTANCE", null, null);
    public static final AuthenticatedReturnCode EBICS_RECOVERY_NOT_SUPPORTED = new AuthenticatedReturnCode("091105", "EBICS_RECOVERY_NOT_SUPPORTED", null, null);
    public static final AuthenticatedReturnCode EBICS_INVALID_SIGNATURE_FILE_FORMAT = new AuthenticatedReturnCode("091111", "EBICS_INVALID_SIGNATURE_FILE_FORMAT", null, null);
    public static final AuthenticatedReturnCode EBICS_ORDERID_UNKNOWN = new AuthenticatedReturnCode("091114", "EBICS_ORDERID_UNKNOWN", null, null);
    public static final AuthenticatedReturnCode EBICS_ORDERID_ALREADY_EXISTS = new AuthenticatedReturnCode("091115", "EBICS_ORDERID_ALREADY_EXISTS", null, ProtocolVersion.H004);
    public static final AuthenticatedReturnCode EBICS_ORDERID_ALREADY_FINAL = new AuthenticatedReturnCode("091115", "EBICS_ORDERID_ALREADY_FINAL", ProtocolVersion.H005, null);
    public static final AuthenticatedReturnCode EBICS_PROCESSING_ERROR = new AuthenticatedReturnCode("091116", "EBICS_PROCESSING_ERROR", null, null);
    public static final AuthenticatedReturnCode EBICS_KEYMGMT_UNSUPPORTED_VERSION_SIGNATURE = new AuthenticatedReturnCode("091201", "EBICS_KEYMGMT_UNSUPPORTED_VERSION_SIGNATURE", null, null);
    public static final AuthenticatedReturnCode EBICS_KEYMGMT_UNSUPPORTED_VERSION_AUTHENTICATION = new AuthenticatedReturnCode("091202", "EBICS_KEYMGMT_UNSUPPORTED_VERSION_AUTHENTICATION", null, null);
    public static final AuthenticatedReturnCode EBICS_KEYMGMT_UNSUPPORTED_VERSION_ENCRYPTION = new AuthenticatedReturnCode("091203", "EBICS_KEYMGMT_UNSUPPORTED_VERSION_ENCRYPTION", null, null);
    public static final AuthenticatedReturnCode EBICS_KEYMGMT_KEYLENGTH_ERROR_SIGNATURE = new AuthenticatedReturnCode("091204", "EBICS_KEYMGMT_KEYLENGTH_ERROR_SIGNATURE", null, null);
    public static final AuthenticatedReturnCode EBICS_KEYMGMT_KEYLENGTH_ERROR_AUTHENTICATION = new AuthenticatedReturnCode("091205", "EBICS_KEYMGMT_KEYLENGTH_ERROR_AUTHENTICATION", null, null);
    public static final AuthenticatedReturnCode EBICS_KEYMGMT_KEYLENGTH_ERROR_ENCRYPTION = new AuthenticatedReturnCode("091206", "EBICS_KEYMGMT_KEYLENGTH_ERROR_ENCRYPTION", null, null);
    public static final AuthenticatedReturnCode EBICS_KEYMGMT_NO_X509_SUPPORT = new AuthenticatedReturnCode("091207", "EBICS_KEYMGMT_NO_X509_SUPPORT", null, null);
    public static final AuthenticatedReturnCode EBICS_X509_CERTIFICATE_EXPIRED = new AuthenticatedReturnCode("091208", "EBICS_X509_CERTIFICATE_EXPIRED", null, null);
    public static final AuthenticatedReturnCode EBICS_X509_CERTIFICATE_NOT_VALID_YET = new AuthenticatedReturnCode("091209", "EBICS_X509_CERTIFICATE_NOT_VALID_YET", null, null);
    public static final AuthenticatedReturnCode EBICS_X509_WRONG_KEY_USAGE = new AuthenticatedReturnCode("091210", "EBICS_X509_WRONG_KEY_USAGE", null, null);
    public static final AuthenticatedReturnCode EBICS_X509_WRONG_ALGORITHM = new AuthenticatedReturnCode("091211", "EBICS_X509_WRONG_ALGORITHM", null, null);
    public static final AuthenticatedReturnCode EBICS_X509_INVALID_THUMBPRINT = new AuthenticatedReturnCode("091212", "EBICS_X509_INVALID_THUMBPRINT", null, null);
    public static final AuthenticatedReturnCode EBICS_X509_CTL_INVALID = new AuthenticatedReturnCode("091213", "EBICS_X509_CTL_INVALID", null, null);
    public static final AuthenticatedReturnCode EBICS_X509_UNKNOWN_CERTIFICATE_AUTHORITY = new AuthenticatedReturnCode("091214", "EBICS_X509_UNKNOWN_CERTIFICATE_AUTHORITY", null, null);
    public static final AuthenticatedReturnCode EBICS_X509_INVALID_POLICY = new AuthenticatedReturnCode("091215", "EBICS_X509_INVALID_POLICY", null, null);
    public static final AuthenticatedReturnCode EBICS_X509_INVALID_BASIC_CONSTRAINTS = new AuthenticatedReturnCode("091216", "EBICS_X509_INVALID_BASIC_CONSTRAINTS", null, null);
    public static final AuthenticatedReturnCode EBICS_ONLY_X509_SUPPORT = new AuthenticatedReturnCode("091217", "EBICS_ONLY_X509_SUPPORT", null, null);
    public static final AuthenticatedReturnCode EBICS_KEYMGMT_DUPLICATE_KEY = new AuthenticatedReturnCode("091218", "EBICS_KEYMGMT_DUPLICATE_KEY", null, null);
    public static final AuthenticatedReturnCode EBICS_CERTIFICATES_VALIDATION_ERROR = new AuthenticatedReturnCode("091219", "EBICS_CERTIFICATES_VALIDATION_ERROR", null, null);
    public static final AuthenticatedReturnCode EBICS_SIGNATURE_VERIFICATION_FAILED = new AuthenticatedReturnCode("091301", "EBICS_SIGNATURE_VERIFICATION_FAILED", null, null);
    public static final AuthenticatedReturnCode EBICS_ACCOUNT_AUTHORISATION_FAILED = new AuthenticatedReturnCode("091302", "EBICS_ACCOUNT_AUTHORISATION_FAILED", null, null);
    public static final AuthenticatedReturnCode EBICS_AMOUNT_CHECK_FAILED = new AuthenticatedReturnCode("091303", "EBICS_AMOUNT_CHECK_FAILED", null, null);
    public static final AuthenticatedReturnCode EBICS_SIGNER_UNKNOWN = new AuthenticatedReturnCode("091304", "EBICS_SIGNER_UNKNOWN", null, null);
    public static final AuthenticatedReturnCode EBICS_INVALID_SIGNER_STATE = new AuthenticatedReturnCode("091305", "EBICS_INVALID_SIGNER_STATE", null, null);
    public static final AuthenticatedReturnCode EBICS_DUPLICATE_SIGNATURE = new AuthenticatedReturnCode("091306", "EBICS_DUPLICATE_SIGNATURE", null, null);

    @Deprecated
    public AuthenticatedReturnCode(ProtocolVersion pv) {
        super(pv);
    }

    private AuthenticatedReturnCode(String value, String key, ProtocolVersion minVersion, ProtocolVersion maxVersion) {
        super(value, minVersion, maxVersion);
        String s = SYMBOLIC_NAMES.put(this, key);
        if (s != null && !s.equals(key)) {
            throw new RuntimeException("Different key='" + key + "' added for value='" + value + "'");
        }
    }

    public void throwException() throws EbicsException {
        if (this.value.startsWith("00") || this.value.startsWith("01") || this.value.startsWith("03")) {
            return;
        }
        if (this.equals(EBICS_SIGNATURE_VERIFICATION_FAILED)) {
            throw new SignatureVerificationFailedException();
        }
        if (EBICS_AUTHORISATION_ORDER_TYPE_FAILED.valueEquals(this)) {
            throw new AuthorisationFailedException();
        }
        if (this.equals(EBICS_NO_DOWNLOAD_DATA_AVAILABLE)) {
            throw new NoDownloadDataAvailableException();
        }
        if (this.equals(EBICS_SIGNER_UNKNOWN)) {
            throw new SignerUnknownException();
        }
        if (this.equals(EBICS_DUPLICATE_SIGNATURE)) {
            throw new DuplicateSignatureException();
        }
        if (this.equals(EBICS_INVALID_SIGNER_STATE)) {
            throw new InvalidSignerStateException();
        }
        if (this.equals(EBICS_INVALID_ORDER_DATA_FORMAT)) {
            throw new InvalidOrderDataFormatException();
        }
        if (this.equals(EBICS_KEYMGMT_DUPLICATE_KEY)) {
            throw new KeymgmtDuplicateKeyException();
        }
        if (this.equals(EBICS_INVALID_SIGNATURE_FILE_FORMAT)) {
            throw new InvalidSignatureFileFormatException();
        }
        if (this.equals(EBICS_KEYMGMT_NO_X509_SUPPORT)) {
            throw new KeymgmtNoX509SupportException();
        }
        EbicsException toThrow = new EbicsException(this);
        toThrow.setReportText(this.getSymbolicName());
        throw toThrow;
    }

    @Override
    public String getSymbolicName() {
        return SYMBOLIC_NAMES.get(this);
    }

    @Override
    public void addAttributes(EbicsPrintStream ps) {
        ps.addAttribute("authenticate", "true");
    }

    @Override
    public void setAttributes(EbicsAttributes attributes) throws SAXException {
        attributes.checkFixed("authenticate", "true");
    }

    @Override
    public String getText(Locale l) {
        ResourceBundle bundle = ResourceBundle.getBundle("de.businesslogics.ebics.schema.types.AuthenticatedReportText", l);
        try {
            return bundle.getString(this.getBundleKey());
        }
        catch (MissingResourceException mr) {
            return "[" + this.getSymbolicName() + "] " + this.getValue();
        }
    }

    public static Collection<AuthenticatedReturnCode> getAuthenticatedInstances() {
        return Collections.unmodifiableCollection(SYMBOLIC_NAMES.keySet());
    }
}

