/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.types;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.ebics.schema.types.AccountHolderRole;
import de.businesslogics.ebics.schema.types.AccountNumber;
import de.businesslogics.ebics.schema.types.AccountNumberRole;
import de.businesslogics.ebics.schema.types.BankCode;
import de.businesslogics.ebics.schema.types.BankCodeRole;
import de.businesslogics.ebics.schema.types.NationalAccountNumber;
import de.businesslogics.ebics.schema.types.NationalBankcode;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.util.Currency;
import de.businesslogics.util.StringUtils;
import org.xml.sax.SAXException;

public class AttributedAccount
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private SimpleStringElement accountNumber;
    private SimpleStringElement accountNumber2;
    private SimpleStringElement bankCode;
    private SimpleStringElement bankCode2;
    Currency currency = Currency.getInstance("EUR");
    String description = null;
    MyAccountHolder accountHolder;

    @Deprecated
    public AttributedAccount() {
    }

    public AttributedAccount(SimpleStringElement accountNumber, SimpleStringElement bankCode) {
        this.accountNumber = accountNumber;
        this.bankCode = bankCode;
    }

    public SimpleStringElement getAccountNumber2() {
        return this.accountNumber2;
    }

    public void setAccountNumber2(SimpleStringElement accountNumber2) {
        this.accountNumber2 = accountNumber2;
    }

    public SimpleStringElement getBankCode2() {
        return this.bankCode2;
    }

    public void setBankCode2(SimpleStringElement bankCode2) {
        this.bankCode2 = bankCode2;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public MyAccountHolder getAccountHolder() {
        return this.accountHolder;
    }

    public void setAccountHolder(String holder, AccountHolderRole role) {
        this.accountHolder = StringUtils.isEmpty(holder) ? null : new MyAccountHolder(holder, role);
    }

    public void setAccountHolder(MyAccountHolder accountHolder) {
        this.accountHolder = accountHolder;
    }

    public SimpleStringElement getAccountNumber() {
        return this.accountNumber;
    }

    public SimpleStringElement getBankCode() {
        return this.bankCode;
    }

    @Override
    protected void addAttributes(EbicsPrintStream ps) {
        if (!"EUR".equals(this.currency.getCurrencyCode())) {
            ps.addAttribute("Currency", this.currency.getCurrencyCode());
        }
        if (this.description != null) {
            ps.addAttribute("Description", this.description);
        }
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        if (this.accountNumber instanceof MyAccountNumber) {
            this.accountNumber.printOut("AccountNumber", ps);
        } else {
            this.accountNumber.printOut("NationalAccountNumber", ps);
        }
        if (this.accountNumber2 != null) {
            if (this.accountNumber2 instanceof MyAccountNumber) {
                this.accountNumber2.printOut("AccountNumber", ps);
            } else {
                this.accountNumber2.printOut("NationalAccountNumber", ps);
            }
        }
        if (this.bankCode != null) {
            if (this.bankCode instanceof MyBankCode) {
                this.bankCode.printOut("BankCode", ps);
            } else {
                this.bankCode.printOut("NationalBankCode", ps);
            }
        }
        if (this.bankCode2 != null) {
            if (this.bankCode2 instanceof MyBankCode) {
                this.bankCode2.printOut("BankCode", ps);
            } else {
                this.bankCode2.printOut("NationalBankCode", ps);
            }
        }
        ps.printOut("AccountHolder", this.accountHolder);
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            ProtocolVersion version = ProtocolVersion.fromNameSpace(uri);
            if (localName.equals("AccountNumber")) {
                if (parser.allowChild(0)) {
                    this.accountNumber = new MyAccountNumber();
                    return this.accountNumber;
                }
                if (parser.allowChild(1)) {
                    this.accountNumber2 = new MyAccountNumber();
                    return this.accountNumber2;
                }
            }
            if (localName.equals("NationalAccountNumber")) {
                if (parser.allowChild(0)) {
                    this.accountNumber = new MyNationalAccountNumber();
                    return this.accountNumber;
                }
                if (parser.allowChild(1)) {
                    this.accountNumber2 = new MyNationalAccountNumber();
                    return this.accountNumber2;
                }
            }
            if (localName.equals("BankCode")) {
                if (parser.allowChild(0, 2)) {
                    this.bankCode = new MyBankCode();
                    return this.bankCode;
                }
                if (parser.allowChild(3)) {
                    this.bankCode2 = new MyBankCode();
                    return this.bankCode2;
                }
            }
            if (localName.equals("NationalBankCode")) {
                if (parser.allowChild(0, 2)) {
                    this.bankCode = new MyNationalBankCode();
                    return this.bankCode;
                }
                if (parser.allowChild(3)) {
                    this.bankCode2 = new MyNationalBankCode();
                    return this.bankCode2;
                }
            }
            if (localName.equals("AccountHolder") && parser.allowChild(version.compareTo(ProtocolVersion.H004) > 0 ? 0 : 2, 4)) {
                this.accountHolder = new MyAccountHolder();
                return this.accountHolder;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        ProtocolVersion pv = ProtocolVersion.fromNameSpace(parser.getParentUri());
        parser.checkLastMandatory(pv.compareTo(ProtocolVersion.H004) > 0 ? 0 : 2);
    }

    @Override
    protected void setAttributes(EbicsAttributes attributes) throws SAXException {
        this.currency = Currency.getInstance(attributes.getValueWithDefault("Currency", "EUR"));
        this.description = attributes.getValue("Description");
    }

    public static MyBankCode mkBIC(ProtocolVersion pv, String bic, BankCodeRole role) {
        if ((bic == null || "NOTPROVIDED".equals(bic)) && pv.getVersion() >= 5) {
            return null;
        }
        if (bic == null) {
            bic = "NOTPROVIDED";
        }
        MyBankCode toReturn = new MyBankCode(bic, role);
        toReturn.setInternational(true);
        return toReturn;
    }

    public static class MyAccountHolder
    extends SimpleStringElement {
        private static final long serialVersionUID = 1L;
        private String description;
        private AccountHolderRole role;

        @Deprecated
        private MyAccountHolder() {
        }

        public MyAccountHolder(String value, AccountHolderRole role) {
            super(value);
            this.role = role;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public AccountHolderRole getRole() {
            return this.role;
        }

        @Override
        public void addAttributes(EbicsPrintStream ps) {
            ps.addAttribute("Role", this.role.toString());
            ps.addAttribute("Description", this.description);
        }

        @Override
        protected void setAttributes(EbicsAttributes attributes) throws SAXException {
            this.description = attributes.getValue("Description");
            this.role = AccountHolderRole.get(attributes.getMandatoryValue("Role"));
        }
    }

    public static class MyAccountNumber
    extends AccountNumber {
        private static final long serialVersionUID = 1L;
        private AccountNumberRole role;
        private String description;

        @Deprecated
        private MyAccountNumber() {
        }

        public MyAccountNumber(String number, AccountNumberRole role, boolean international) {
            super(number, international);
            this.role = role;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public AccountNumberRole getRole() {
            return this.role;
        }

        @Override
        public void addAttributes(EbicsPrintStream ps) {
            super.addAttributes(ps);
            ps.addAttribute("Role", this.role.toString());
            if (this.description != null) {
                ps.addAttribute("Description", this.description);
            }
        }

        @Override
        protected void setAttributes(EbicsAttributes attributes) throws SAXException {
            super.setAttributes(attributes);
            this.role = AccountNumberRole.get(attributes.getMandatoryValue("Role"));
            this.description = attributes.getValue("Description");
        }
    }

    public static class MyBankCode
    extends BankCode {
        private static final long serialVersionUID = 1L;
        private BankCodeRole role;
        private String description;

        @Deprecated
        private MyBankCode() {
        }

        public MyBankCode(String s, BankCodeRole role) {
            super(s);
            this.role = role;
        }

        @Override
        public void addAttributes(EbicsPrintStream ps) {
            super.addAttributes(ps);
            ps.addAttribute("Role", this.role.toString());
            if (this.description != null) {
                ps.addAttribute("Description", this.description);
            }
        }

        @Override
        protected void setAttributes(EbicsAttributes attributes) throws SAXException {
            super.setAttributes(attributes);
            this.role = BankCodeRole.get(attributes.getMandatoryValue("Role"));
            this.description = attributes.getValue("Description");
        }

        public BankCodeRole getRole() {
            return this.role;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    public static class MyNationalAccountNumber
    extends NationalAccountNumber {
        private static final long serialVersionUID = 1L;
        private AccountNumberRole role;
        private String description;

        @Deprecated
        private MyNationalAccountNumber() {
        }

        public MyNationalAccountNumber(String number, AccountNumberRole role, String format) {
            super(number, format);
            this.role = role;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public AccountNumberRole getRole() {
            return this.role;
        }

        @Override
        public void addAttributes(EbicsPrintStream ps) {
            super.addAttributes(ps);
            ps.addAttribute("Role", this.role.toString());
            if (this.description != null) {
                ps.addAttribute("Description", this.description);
            }
        }

        @Override
        protected void setAttributes(EbicsAttributes attributes) throws SAXException {
            super.setAttributes(attributes);
            this.role = AccountNumberRole.get(attributes.getMandatoryValue("Role"));
            this.description = attributes.getValue("Description");
        }
    }

    public static class MyNationalBankCode
    extends NationalBankcode {
        private static final long serialVersionUID = 1L;
        private BankCodeRole role;
        private String description;

        @Deprecated
        private MyNationalBankCode() {
        }

        public MyNationalBankCode(String s, BankCodeRole role, String format) {
            super(s, format);
            this.role = role;
        }

        @Override
        public void addAttributes(EbicsPrintStream ps) {
            super.addAttributes(ps);
            ps.addAttribute("Role", this.role.toString());
            if (this.description != null) {
                ps.addAttribute("Description", this.description);
            }
        }

        @Override
        protected void setAttributes(EbicsAttributes attributes) throws SAXException {
            super.setAttributes(attributes);
            this.role = BankCodeRole.get(attributes.getMandatoryValue("Role"));
            this.description = attributes.getValue("Description");
        }

        public BankCodeRole getRole() {
            return this.role;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }
}

