/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.signature;

import de.businesslogics.ebics.schema.Base64Element;
import de.businesslogics.ebics.schema.ChoiceElement;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.ebics.schema.response.InvalidOrderDataFormatException;
import de.businesslogics.ebics.schema.signature.X509IssuerSerial;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

public class X509Data
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private final List<Choice> choices = new ArrayList<Choice>(1);

    public X509Data() {
    }

    public X509Data(List<X509Certificate> certs) {
        try {
            for (X509Certificate x509 : certs) {
                byte[] b = x509.getEncoded();
                Choice c = Choice.fromX509Certificate(new Base64Element(b));
                this.choices.add(c);
            }
        }
        catch (GeneralSecurityException gse) {
            throw new RuntimeException(gse);
        }
    }

    public List<Choice> getChoices() {
        return this.choices;
    }

    public Object[] getMainKey() throws InvalidOrderDataFormatException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ArrayList<Base64Element> encodings = new ArrayList<Base64Element>();
        try {
            for (Choice c : this.getChoices()) {
                Base64Element x509Certificate = c.getX509Certificate();
                if (x509Certificate == null) continue;
                encodings.add(x509Certificate);
                bos.write(x509Certificate.getValue());
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        byte[] cert = bos.toByteArray();
        ArrayList<X509Certificate> x509s = new ArrayList<X509Certificate>(encodings.size());
        ByteArrayInputStream bis = new ByteArrayInputStream(cert);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            while (x509s.size() < encodings.size()) {
                x509s.add((X509Certificate)cf.generateCertificate(bis));
            }
            Certificate main = cf.generateCertPath(x509s).getCertificates().get(0);
            int i = 0;
            while (x509s.get(i) != main) {
                ++i;
            }
            Object[] toReturn = new Object[]{main, ((Base64Element)encodings.get(i)).getValue()};
            return toReturn;
        }
        catch (CertificateException ce) {
            InvalidOrderDataFormatException toThrow = new InvalidOrderDataFormatException();
            toThrow.initCause(ce);
            throw toThrow;
        }
    }

    public List<X509Certificate> getCertificates() throws InvalidOrderDataFormatException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ArrayList<Base64Element> encodings = new ArrayList<Base64Element>();
        try {
            for (Choice c : this.getChoices()) {
                Base64Element x509Certificate = c.getX509Certificate();
                if (x509Certificate == null) continue;
                encodings.add(x509Certificate);
                bos.write(x509Certificate.getValue());
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        byte[] cert = bos.toByteArray();
        ArrayList<X509Certificate> x509s = new ArrayList<X509Certificate>(encodings.size());
        ByteArrayInputStream bis = new ByteArrayInputStream(cert);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            while (x509s.size() < encodings.size()) {
                x509s.add((X509Certificate)cf.generateCertificate(bis));
            }
            return x509s;
        }
        catch (CertificateException ce) {
            InvalidOrderDataFormatException toThrow = new InvalidOrderDataFormatException();
            toThrow.initCause(ce);
            throw toThrow;
        }
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String name) throws SAXException {
        if (Choice.matches(parser, uri, localName) && parser.allowOrIsChild(0)) {
            Choice toReturn = new Choice();
            this.choices.add(toReturn);
            return toReturn;
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(0);
    }

    @Override
    protected void printValue(EbicsPrintStream ps) {
        for (Choice c : this.choices) {
            c.printValue(ps);
        }
    }

    public static class Choice
    extends ChoiceElement {
        private static final long serialVersionUID = 1L;

        private Choice() {
        }

        protected Choice(String elementName, EbicsElement element) {
            super(elementName, element);
        }

        public static Choice fromX509Certificate(Base64Element x509Certificate) {
            return new Choice("X509Certificate", x509Certificate);
        }

        public Base64Element getX509Certificate() {
            return this.get(Base64Element.class, "X509Certificate");
        }

        public X509IssuerSerial getX509IssuerSerial() {
            return this.get(X509IssuerSerial.class, "X509IssuerSerial");
        }

        public Base64Element getX509SKI() {
            return this.get(Base64Element.class, "X509SKI");
        }

        public SimpleStringElement getX509SubjectName() {
            return this.get(SimpleStringElement.class, "X509SubjectName");
        }

        public Base64Element getX590CRL() {
            return this.get(Base64Element.class, "X590CRL");
        }

        @Override
        protected EbicsElement createChild(ElementParser parser, String uri, String localName, String name) throws SAXException {
            if (parser.isParentUri(uri) && parser.allowChild(0)) {
                if (localName.equals("X509IssuerSerial")) {
                    return this.setElement(localName, new X509IssuerSerial());
                }
                if (localName.equals("X509SKI")) {
                    return this.setElement(localName, new Base64Element());
                }
                if (localName.equals("X509SubjectName")) {
                    return this.setElement(localName, new SimpleStringElement());
                }
                if (localName.equals("X509Certificate")) {
                    return this.setElement(localName, new Base64Element());
                }
                if (localName.equals("X590CRL")) {
                    return this.setElement(localName, new Base64Element());
                }
            }
            return null;
        }

        @Override
        protected void endElement(ElementParser parser) throws SAXException {
            parser.checkLastMandatory(0);
        }

        public static boolean matches(ElementParser parser, String uri, String localName) {
            return parser.isParentUri(uri) && (localName.equals("X509IssuerSerial") || localName.equals("X509SKI") || localName.equals("X509SubjectName") || localName.equals("X509Certificate") || localName.equals("X590CRL"));
        }
    }
}

