/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.signature;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.response.AuthenticationFailedException;
import de.businesslogics.ebics.schema.signature.CanonicalizationMethod;
import de.businesslogics.ebics.schema.signature.DigestMethod;
import de.businesslogics.ebics.schema.signature.Reference;
import de.businesslogics.ebics.schema.signature.SignatureMethod;
import de.businesslogics.ebics.schema.signature.Transform;
import de.businesslogics.ebics.schema.signature.WrongDigestException;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.util.HexTool;
import java.util.Arrays;
import java.util.logging.Logger;
import org.xml.sax.SAXException;

public class SignedInfo
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(SignedInfo.class.getName());
    private CanonicalizationMethod canonicalizationMethod;
    private SignatureMethod signatureMethod;
    private Reference reference;

    public SignedInfo() {
    }

    public SignedInfo(CanonicalizationMethod canonicalizationMethod, SignatureMethod signatureMethod, Reference reference) {
        this.canonicalizationMethod = canonicalizationMethod;
        this.signatureMethod = signatureMethod;
        this.reference = reference;
    }

    public CanonicalizationMethod getCanonicalizationMethod() {
        return this.canonicalizationMethod;
    }

    public Reference getReference() {
        return this.reference;
    }

    public SignatureMethod getSignatureMethod() {
        return this.signatureMethod;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.canonicalizationMethod.printOut("ds:CanonicalizationMethod", ps);
        this.signatureMethod.printOut("ds:SignatureMethod", ps);
        this.reference.printOut("ds:Reference", ps);
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (localName.equals("CanonicalizationMethod") && parser.allowChild(0)) {
            this.canonicalizationMethod = new CanonicalizationMethod();
            return this.canonicalizationMethod;
        }
        if (localName.equals("SignatureMethod") && parser.allowChild(1)) {
            this.signatureMethod = new SignatureMethod();
            return this.signatureMethod;
        }
        if (localName.equals("Reference") && parser.allowChild(2)) {
            this.reference = new Reference();
            return this.reference;
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(2);
    }

    @Override
    protected void setAttributes(EbicsAttributes attributes) throws SAXException {
        attributes.getValue("Id");
    }

    public void checkAuthentication(ProtocolVersion protocolVersion, byte[] digest) throws AuthenticationFailedException {
        DigestMethod dm;
        SignatureMethod sm;
        if (protocolVersion == ProtocolVersion.H002) {
            sm = SignatureMethod.RSA_SHA1;
            dm = DigestMethod.SHA1;
        } else {
            sm = SignatureMethod.RSA_SHA256;
            dm = DigestMethod.SHA256;
        }
        if (!this.canonicalizationMethod.equals(CanonicalizationMethod.C14N)) {
            LOGGER.info("Wrong canonicalization method: " + this.canonicalizationMethod.getAlogrithm());
            throw new AuthenticationFailedException();
        }
        if (!this.signatureMethod.equals(sm)) {
            LOGGER.info("Wrong signature method: " + this.signatureMethod.getAlogrithm());
            throw new AuthenticationFailedException();
        }
        if (!this.reference.getTransforms().getTransform().equals(Transform.C14N)) {
            LOGGER.info("Wrong transform: " + this.reference.getTransforms().getTransform().getAlogrithm());
            throw new AuthenticationFailedException();
        }
        if (!this.reference.getDigestMethod().equals(dm)) {
            LOGGER.info("Wrong digest method: " + this.reference.getDigestMethod().getAlogrithm());
            throw new AuthenticationFailedException();
        }
        if (!Arrays.equals(this.reference.getDigestValue().getValue(), digest)) {
            LOGGER.info("differing digests: found " + HexTool.toHex(this.reference.getDigestValue().getValue()) + " but expected " + HexTool.toHex(digest));
            throw new WrongDigestException(digest, this.reference.getDigestValue().getValue());
        }
    }
}

