/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.signature;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.signature.SignatureValue;
import de.businesslogics.ebics.schema.signature.SignedInfo;
import org.xml.sax.SAXException;

public class Signature
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private SignedInfo signedInfo;
    private SignatureValue signatureValue;

    public Signature() {
    }

    public Signature(SignedInfo signedInfo, SignatureValue signatureValue) {
        this.signedInfo = signedInfo;
        this.signatureValue = signatureValue;
    }

    public SignatureValue getSignatureValue() {
        return this.signatureValue;
    }

    public SignedInfo getSignedInfo() {
        return this.signedInfo;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.signedInfo.printOut("ds:SignedInfo", ps);
        this.signatureValue.printOut("ds:SignatureValue", ps);
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if ("http://www.w3.org/2000/09/xmldsig#".equals(uri)) {
            if (localName.equals("SignedInfo") && parser.allowChild(0)) {
                this.signedInfo = new SignedInfo();
                return this.signedInfo;
            }
            if (localName.equals("SignatureValue") && parser.allowChild(1)) {
                this.signatureValue = new SignatureValue();
                return this.signatureValue;
            }
        }
        return null;
    }

    @Override
    protected void setAttributes(EbicsAttributes attributes) throws SAXException {
        attributes.ignore("Id");
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(1);
    }
}

