/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.signature;

import de.businesslogics.ebics.schema.Base64Element;
import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.signature.DigestMethod;
import de.businesslogics.ebics.schema.signature.Transforms;
import org.xml.sax.SAXException;

public class Reference
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private String uri;
    private Transforms transforms;
    private DigestMethod digestMethod;
    private Base64Element digestValue;

    public Reference() {
    }

    public Reference(String uri, Transforms transforms, DigestMethod digestMethod, Base64Element digestValue) {
        this.uri = uri;
        this.transforms = transforms;
        this.digestMethod = digestMethod;
        this.digestValue = digestValue;
    }

    public DigestMethod getDigestMethod() {
        return this.digestMethod;
    }

    public Base64Element getDigestValue() {
        return this.digestValue;
    }

    public Transforms getTransforms() {
        return this.transforms;
    }

    public String getUri() {
        return this.uri;
    }

    @Override
    protected void addAttributes(EbicsPrintStream ps) {
        ps.addAttribute("URI", this.uri);
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.transforms.printOut("ds:Transforms", ps);
        this.digestMethod.printOut("ds:DigestMethod", ps);
        this.digestValue.printOut("ds:DigestValue", ps);
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String _uri, String localName, String qName) throws SAXException {
        if (localName.equals("Transforms") && parser.allowChild(0)) {
            this.transforms = new Transforms();
            return this.transforms;
        }
        if (localName.equals("DigestMethod") && parser.allowChild(1)) {
            this.digestMethod = new DigestMethod();
            return this.digestMethod;
        }
        if (localName.equals("DigestValue") && parser.allowChild(2)) {
            this.digestValue = new Base64Element();
            return this.digestValue;
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(2);
    }

    @Override
    protected void setAttributes(EbicsAttributes attributes) throws SAXException {
        this.uri = attributes.getMandatoryValue("URI");
        attributes.ignore("Id");
    }
}

