/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.signature;

import de.businesslogics.ebics.schema.Base64Element;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.util.HexTool;
import de.businesslogics.zkasecurity.DirectSecurity;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import org.xml.sax.SAXException;

public class RSAKeyValue
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    public static final String NS_URI = "http://www.w3.org/2000/09/xmldsig#";
    private Base64Element modulus;
    private Base64Element exponent;

    public RSAKeyValue() {
    }

    public RSAKeyValue(RSAPublicKey key) {
        this.modulus = new Base64Element(HexTool.stripZeros(key.getModulus().toByteArray()));
        this.exponent = new Base64Element(HexTool.stripZeros(key.getPublicExponent().toByteArray()));
    }

    public RSAKeyValue(Base64Element modulus, Base64Element exponent) {
        this.modulus = modulus;
        this.exponent = exponent;
    }

    public Base64Element getModulus() {
        return this.modulus;
    }

    public Base64Element getExponent() {
        return this.exponent;
    }

    public RSAPublicKey getPublicKey() {
        BigInteger pubExp = new BigInteger(1, this.exponent.getValue());
        BigInteger mod = new BigInteger(1, this.modulus.getValue());
        RSAPublicKeySpec spec = new RSAPublicKeySpec(mod, pubExp);
        return (RSAPublicKey)DirectSecurity.getRSAKeyFactory().generatePublic(spec);
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (uri.equals(NS_URI)) {
            if (localName.equals("Modulus") && parser.allowChild(0)) {
                this.modulus = new Base64Element();
                return this.modulus;
            }
            if (localName.equals("Exponent") && parser.allowChild(1)) {
                this.exponent = new Base64Element();
                return this.exponent;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(1);
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.modulus.printOut("ds:Modulus", ps);
        this.exponent.printOut("ds:Exponent", ps);
    }
}

