/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.sctinst.h005;

import de.businesslogics.ebics.schema.AuthenticableRootElement;
import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.EbicsRootElement;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.response.InvalidRequestException;
import de.businesslogics.ebics.schema.sctinst.h005.DataTransferInstantRequestType;
import de.businesslogics.ebics.schema.sctinst.h005.StaticHeaderInstantRequestType;
import de.businesslogics.ebics.schema.signature.Signature;
import de.businesslogics.ebics.schema.types.Nonce;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.TimeStamp;
import org.xml.sax.SAXException;

public class EbicsInstRequest
extends EbicsRootElement
implements AuthenticableRootElement {
    private static final long serialVersionUID = 1L;
    private int revision;
    private final ProtocolVersion version;
    private InstHeader header;
    private Signature authSignature = null;
    private InstBody body;

    public EbicsInstRequest(ProtocolVersion version) {
        this.version = version;
    }

    public EbicsInstRequest(ProtocolVersion version, StaticHeaderInstantRequestType header, InstBody body) {
        this.version = version;
        this.header = new InstHeader(header);
        this.body = body;
    }

    public int getRevision() {
        return this.revision;
    }

    @Override
    public ProtocolVersion getVersion() {
        return this.version;
    }

    public StaticHeaderInstantRequestType getHeader() {
        return this.header.getStatic();
    }

    public InstBody getBody() {
        return this.body;
    }

    @Override
    public Signature getAuthSignature() {
        return this.authSignature;
    }

    @Override
    public void setAuthSignature(Signature signature) {
        this.authSignature = signature;
    }

    @Override
    public Nonce getNonce() throws InvalidRequestException {
        return this.header.getStatic().getNonce();
    }

    @Override
    public TimeStamp getTimestamp() throws InvalidRequestException {
        return this.header.getStatic().getTimeStamp();
    }

    @Override
    public String name() {
        return "ebicsInstRequest";
    }

    @Override
    protected void addAttributes(EbicsPrintStream ps) {
        ps.addAttribute("Version", this.version.getValue());
        ps.addAttribute("Revision", "1");
    }

    @Override
    public void setAttributes(EbicsAttributes attributes) throws SAXException {
        attributes.checkFixed("Version", this.version.getValue());
        this.revision = attributes.getInt("Revision", 1);
        if (this.revision < 1 || this.revision > 99) {
            throw new SAXException("Ebics revision=" + this.revision + " out of range");
        }
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.header.printOut("header", ps);
        if (this.authSignature != null) {
            this.authSignature.printOut("AuthSignature", ps);
        }
        this.body.printOut("body", ps);
    }

    @Override
    protected void addNamespaceDecls(EbicsPrintStream ps) {
        ps.addNamespaceDecl("", this.version.getNamespace());
        ps.addNamespaceDecl("ds", "http://www.w3.org/2000/09/xmldsig#");
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if (localName.equals("header") && parser.allowChild(0)) {
                this.header = new InstHeader();
                return this.header;
            }
            if (localName.equals("AuthSignature") && parser.allowChild(1)) {
                this.authSignature = new Signature();
                return this.authSignature;
            }
            if (localName.equals("body") && parser.allowChild(2)) {
                this.body = new InstBody();
                return this.body;
            }
        }
        return null;
    }

    @Override
    public void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(2);
    }

    public static ElementParser createParser(ProtocolVersion version) {
        return new EbicsInstRequest(version).createParser();
    }

    public static class InstHeader
    extends EbicsElement {
        private static final long serialVersionUID = 1L;
        private StaticHeaderInstantRequestType sstatic;

        public InstHeader(StaticHeaderInstantRequestType sstatic) {
            this.sstatic = sstatic;
        }

        public InstHeader() {
        }

        @Override
        protected void addAttributes(EbicsPrintStream ps) {
            ps.addAttribute("authenticate", "true");
        }

        @Override
        protected void setAttributes(EbicsAttributes attributes) throws SAXException {
            super.setAttributes(attributes);
            attributes.checkFixed("authenticate", "true");
        }

        public StaticHeaderInstantRequestType getStatic() {
            return this.sstatic;
        }

        @Override
        protected EbicsElement createChild(ElementParser parser, String uri, String localName, String name) throws SAXException {
            if (parser.isParentUri(uri) && localName.equals("static") && parser.allowChild(0)) {
                this.sstatic = new StaticHeaderInstantRequestType();
                return this.sstatic;
            }
            return null;
        }

        @Override
        protected void endElement(ElementParser parser) throws SAXException {
            parser.checkLastMandatory(0);
        }

        @Override
        protected void printValue(EbicsPrintStream ps) {
            this.sstatic.printOut("static", ps);
        }
    }

    public static class InstBody
    extends EbicsElement {
        private static final long serialVersionUID = 1L;
        private DataTransferInstantRequestType dataTransfer;

        public DataTransferInstantRequestType getDataTransfer() {
            return this.dataTransfer;
        }

        public InstBody(DataTransferInstantRequestType dataTransfer) {
            this.dataTransfer = dataTransfer;
        }

        public InstBody() {
        }

        @Override
        protected EbicsElement createChild(ElementParser parser, String uri, String localName, String name) throws SAXException {
            if (parser.isParentUri(uri) && "DataTransfer".equals(localName) && parser.allowChild(0)) {
                this.dataTransfer = new DataTransferInstantRequestType();
                return this.dataTransfer;
            }
            return null;
        }

        @Override
        protected void endElement(ElementParser parser) throws SAXException {
            parser.checkLastMandatory(0);
        }

        @Override
        protected void printValue(EbicsPrintStream ps) {
            ps.printElement(null, "DataTransfer", this.dataTransfer);
        }
    }
}

