/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.s001;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.EbicsRootElement;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.s001.SignaturePubKeyInfoType;
import de.businesslogics.ebics.schema.types.PartnerID;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.UserID;
import org.xml.sax.SAXException;

public class SignaturePubKeyOrderData
extends EbicsRootElement {
    private static final long serialVersionUID = 1L;
    private final String nameSpace;
    private SignaturePubKeyInfoType signaturePubKeyInfo;
    private PartnerID partnerID;
    private UserID userID;

    public SignaturePubKeyOrderData(ProtocolVersion pv) {
        this.nameSpace = pv.compareTo(ProtocolVersion.H004) <= 0 ? "http://www.ebics.org/S001" : "http://www.ebics.org/S002";
    }

    public SignaturePubKeyOrderData(ProtocolVersion pv, SignaturePubKeyInfoType signaturePubKeyInfo, PartnerID partnerID, UserID userID) {
        this(pv);
        this.signaturePubKeyInfo = signaturePubKeyInfo;
        this.partnerID = partnerID;
        this.userID = userID;
    }

    public SignaturePubKeyInfoType getSignaturePubKeyInfo() {
        return this.signaturePubKeyInfo;
    }

    public PartnerID getPartnerID() {
        return this.partnerID;
    }

    public UserID getUserID() {
        return this.userID;
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String name) throws SAXException {
        if (parser.isParentUri(uri)) {
            if (localName.equals("SignaturePubKeyInfo") && parser.allowChild(0)) {
                this.signaturePubKeyInfo = new SignaturePubKeyInfoType();
                return this.signaturePubKeyInfo;
            }
            if (localName.equals("PartnerID") && parser.allowChild(1)) {
                this.partnerID = new PartnerID();
                return this.partnerID;
            }
            if (localName.equals("UserID") && parser.allowChild(2)) {
                this.userID = new UserID();
                return this.userID;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(2);
    }

    @Override
    protected void printValue(EbicsPrintStream ps) {
        this.signaturePubKeyInfo.printOut("SignaturePubKeyInfo", ps);
        this.partnerID.printOut("PartnerID", ps);
        this.userID.printOut("UserID", ps);
    }

    @Override
    protected void addNamespaceDecls(EbicsPrintStream ps) {
        ps.addNamespaceDecl("", this.nameSpace);
        ps.addNamespaceDecl("ds", "http://www.w3.org/2000/09/xmldsig#");
    }

    @Override
    public String name() {
        return "SignaturePubKeyOrderData";
    }

    @Override
    public String namespace() {
        return this.nameSpace;
    }
}

