/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.s001;

import de.businesslogics.ebics.schema.AnyElement;
import de.businesslogics.ebics.schema.Base64Element;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.types.PartnerID;
import de.businesslogics.ebics.schema.types.SignatureVersion;
import de.businesslogics.ebics.schema.types.UserID;
import org.xml.sax.SAXException;

public class OrderSignatureDataType
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private SignatureVersion signatureVersion;
    private Base64Element signatureValue;
    private PartnerID partnerID;
    private UserID userID;

    public OrderSignatureDataType() {
    }

    public OrderSignatureDataType(SignatureVersion signatureVersion, Base64Element signatureValue, PartnerID partnerID, UserID userID) {
        this.signatureVersion = signatureVersion;
        this.signatureValue = signatureValue;
        this.partnerID = partnerID;
        this.userID = userID;
    }

    public SignatureVersion getSignatureVersion() {
        return this.signatureVersion;
    }

    public Base64Element getSignatureValue() {
        return this.signatureValue;
    }

    public PartnerID getPartnerID() {
        return this.partnerID;
    }

    public UserID getUserID() {
        return this.userID;
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String name) throws SAXException {
        if (parser.isParentUri(uri)) {
            if (localName.equals("SignatureVersion") && parser.allowChild(0)) {
                this.signatureVersion = new SignatureVersion();
                return this.signatureVersion;
            }
            if (localName.equals("SignatureValue") && parser.allowChild(1)) {
                this.signatureValue = new Base64Element();
                return this.signatureValue;
            }
            if (localName.equals("PartnerID") && parser.allowChild(2)) {
                this.partnerID = new PartnerID();
                return this.partnerID;
            }
            if (localName.equals("UserID") && parser.allowChild(3)) {
                this.userID = new UserID();
                return this.userID;
            }
        }
        if (uri.equals("http://www.w3.org/2000/09/xmldsig#") && localName.equals("X509Data") && parser.allowChild(4)) {
            return AnyElement.INSTANCE;
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(3);
    }

    @Override
    protected void printValue(EbicsPrintStream ps) {
        this.signatureVersion.printOut("SignatureVersion", ps);
        this.signatureValue.printOut("SignatureValue", ps);
        this.partnerID.printOut("PartnerID", ps);
        this.userID.printOut("UserID", ps);
    }
}

