/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.response;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.request.OrderID;
import de.businesslogics.ebics.schema.response.EbicsException;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.ReportText;
import de.businesslogics.ebics.schema.types.ReturnCode;
import de.businesslogics.ebics.schema.types.SegmentNumber;
import de.businesslogics.ebics.schema.types.TransactionPhase;
import org.xml.sax.SAXException;

public class ResponseMutableHeader
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private TransactionPhase transactionPhase;
    private SegmentNumber segmentNumber;
    private OrderID orderID;
    private ReturnCode returnCode;
    private ReportText reportText;

    @Deprecated
    public ResponseMutableHeader() {
    }

    public ResponseMutableHeader(TransactionPhase transactionPhase, SegmentNumber segmentNumber, ReturnCode returnCode, ReportText reportText) {
        this.transactionPhase = transactionPhase;
        this.segmentNumber = segmentNumber;
        this.returnCode = returnCode;
        this.reportText = reportText;
    }

    public ReportText getReportText() {
        return this.reportText;
    }

    public ReturnCode getReturnCode() {
        return this.returnCode;
    }

    public SegmentNumber getSegmentNumber() {
        return this.segmentNumber;
    }

    public TransactionPhase getTransactionPhase() {
        return this.transactionPhase;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.transactionPhase.printOut("TransactionPhase", ps);
        ps.printOut("SegmentNumber", this.segmentNumber);
        ps.printOut("OrderID", this.orderID);
        this.returnCode.printOut("ReturnCode", ps);
        this.reportText.printOut("ReportText", ps);
    }

    public void throwException() throws EbicsException {
        this.returnCode.throwException(this.reportText);
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if (localName.equals("TransactionPhase") && parser.allowChild(0)) {
                this.transactionPhase = new TransactionPhase();
                return this.transactionPhase;
            }
            if (localName.equals("SegmentNumber") && parser.allowChild(1)) {
                this.segmentNumber = new SegmentNumber();
                return this.segmentNumber;
            }
            if (localName.equals("OrderID") && ProtocolVersion.fromNameSpace(uri).getVersion() >= 4 && parser.allowChild(0, 2)) {
                this.orderID = new OrderID();
                return this.orderID;
            }
            if (localName.equals("ReturnCode") && parser.allowChild(0, 3)) {
                this.returnCode = new ReturnCode(ProtocolVersion.fromNameSpace(uri));
                return this.returnCode;
            }
            if (localName.equals("ReportText") && parser.allowChild(4)) {
                this.reportText = new ReportText();
                return this.reportText;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(4);
    }

    public OrderID getOrderID() {
        return this.orderID;
    }

    public void setOrderID(OrderID orderID) {
        this.orderID = orderID;
    }
}

