/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.response;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.response.ResponseMutableHeader;
import de.businesslogics.ebics.schema.response.ResponseStaticHeader;
import org.xml.sax.SAXException;

public class ResponseHeader
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private ResponseStaticHeader staticHeader;
    private ResponseMutableHeader mutable;

    public ResponseHeader() {
    }

    public ResponseHeader(ResponseStaticHeader staticHeader, ResponseMutableHeader mutable) {
        this.staticHeader = staticHeader;
        this.mutable = mutable;
    }

    @Override
    protected void addAttributes(EbicsPrintStream ps) {
        ps.addAttribute("authenticate", "true");
    }

    @Override
    protected void setAttributes(EbicsAttributes attributes) throws SAXException {
        attributes.checkFixed("authenticate", "true");
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.staticHeader.printOut("static", ps);
        this.mutable.printOut("mutable", ps);
    }

    public ResponseStaticHeader getStatic() {
        return this.staticHeader;
    }

    public ResponseMutableHeader getMutable() {
        return this.mutable;
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if (localName.equals("static") && parser.allowChild(0)) {
                this.staticHeader = new ResponseStaticHeader();
                return this.staticHeader;
            }
            if (localName.equals("mutable") && parser.allowChild(1)) {
                this.mutable = new ResponseMutableHeader();
                return this.mutable;
            }
        }
        return null;
    }

    @Override
    public void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(1);
    }
}

