/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.response;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.request.DataTransfer;
import de.businesslogics.ebics.schema.response.AuthenticatedTimeStamp;
import de.businesslogics.ebics.schema.types.AuthenticatedReturnCode;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import org.xml.sax.SAXException;

public class ResponseBody
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private DataTransfer dataTransfer;
    private AuthenticatedReturnCode returnCode;
    private AuthenticatedTimeStamp timestampBankParameter;

    @Deprecated
    public ResponseBody() {
    }

    public ResponseBody(DataTransfer dataTransfer, AuthenticatedReturnCode returnCode) {
        this.dataTransfer = dataTransfer;
        this.returnCode = returnCode;
    }

    public DataTransfer getDataTransfer() {
        return this.dataTransfer;
    }

    public AuthenticatedReturnCode getReturnCode() {
        return this.returnCode;
    }

    public AuthenticatedTimeStamp getTimestampBankParameter() {
        return this.timestampBankParameter;
    }

    public void setTimestampBankParameter(AuthenticatedTimeStamp timestampBankParameter) {
        this.timestampBankParameter = timestampBankParameter;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        if (this.dataTransfer != null) {
            this.dataTransfer.printOut("DataTransfer", ps);
        }
        this.returnCode.printOut("ReturnCode", ps);
        if (this.timestampBankParameter != null) {
            this.timestampBankParameter.printOut("TimestampBankParameter", ps);
        }
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if ("DataTransfer".equals(localName) && parser.allowChild(0)) {
                this.dataTransfer = new DataTransfer();
                return this.dataTransfer;
            }
            if ("ReturnCode".equals(localName) && parser.allowChild(-1, 1)) {
                this.returnCode = new AuthenticatedReturnCode(ProtocolVersion.fromNameSpace(uri));
                return this.returnCode;
            }
            if ("TimestampBankParameter".equals(localName) && parser.allowChild(2)) {
                this.timestampBankParameter = new AuthenticatedTimeStamp();
                return this.timestampBankParameter;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(1);
    }
}

