/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.response;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.EbicsRootParser;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.response.AuthenticatedTimeStamp;
import de.businesslogics.ebics.schema.response.EbicsException;
import de.businesslogics.ebics.schema.response.MinimalEbicsResponse;
import de.businesslogics.ebics.schema.response.ResponseBody;
import de.businesslogics.ebics.schema.response.ResponseHeader;
import de.businesslogics.ebics.schema.signature.Signature;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import java.io.File;
import org.xml.sax.SAXException;

public class EbicsResponse
extends MinimalEbicsResponse {
    private static final String[] SCHEMA_LOCATIONS = new String[]{ProtocolVersion.H002.getNamespace() + " http://www.ebics.org/H002/ebics_response.xsd", ProtocolVersion.H003.getNamespace() + " http://www.ebics.org/H003/ebics_response.xsd", ProtocolVersion.H004.getNamespace() + " http://www.ebics.org/H004/ebics_response_H004.xsd"};
    private static final long serialVersionUID = 1L;
    private ProtocolVersion version;
    private int revision;
    private ResponseHeader header;
    private Signature signature = null;
    private ResponseBody body;
    public transient File logFile;

    private EbicsResponse() {
    }

    public EbicsResponse(ProtocolVersion version, ResponseHeader header, ResponseBody body) {
        this.version = version;
        this.revision = 1;
        this.header = header;
        this.body = body;
    }

    @Override
    public String name() {
        return "ebicsResponse";
    }

    public ResponseBody getBody() {
        return this.body;
    }

    public ResponseHeader getHeader() {
        return this.header;
    }

    public int getRevision() {
        return this.revision;
    }

    public Signature getAuthSignature() {
        return this.signature;
    }

    @Override
    public AuthenticatedTimeStamp getTimestampBankParameters() {
        return this.body.getTimestampBankParameter();
    }

    public ProtocolVersion getVersion() {
        return this.version;
    }

    public void checkOK() throws EbicsException {
        this.header.getMutable().throwException();
        this.body.getReturnCode().throwException();
    }

    @Override
    protected void addAttributes(EbicsPrintStream ps) {
        if (SCHEMA_LOCATIONS.length > this.version.getVersion() - 2) {
            ps.addAttribute("xsi:schemaLocation", SCHEMA_LOCATIONS[this.version.getVersion() - 2]);
        }
        ps.addAttribute("Version", this.version.getValue());
        ps.addAttribute("Revision", Integer.toString(this.revision));
    }

    @Override
    protected void setAttributes(EbicsAttributes attributes) throws SAXException {
        attributes.checkFixed("Version", this.version.getValue());
        this.revision = attributes.getInt("Revision", 1);
        if (this.revision < 1 || this.revision > 99) {
            throw new SAXException("Ebics revision=" + this.revision + " out of range");
        }
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.header.printOut("header", ps);
        if (this.signature != null) {
            this.signature.printOut("AuthSignature", ps);
        }
        this.body.printOut("body", ps);
    }

    public void setAuthSignature(Signature signature) {
        this.signature = signature;
    }

    @Override
    public void addNamespaceDecls(EbicsPrintStream ps) {
        ps.addNamespaceDecl("", this.version.getNamespace());
        ps.addNamespaceDecl("ds", "http://www.w3.org/2000/09/xmldsig#");
        if (SCHEMA_LOCATIONS.length > this.version.getVersion() - 2) {
            ps.addNamespaceDecl("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        }
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if (localName.equals("header") && parser.allowChild(0)) {
                this.header = new ResponseHeader();
                return this.header;
            }
            if (localName.equals("AuthSignature") && parser.allowChild(1)) {
                this.signature = new Signature();
                return this.signature;
            }
            if (localName.equals("body") && parser.allowChild(2)) {
                this.body = new ResponseBody();
                return this.body;
            }
        }
        return null;
    }

    @Override
    public void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(2);
    }

    public static ElementParser createParser(ProtocolVersion version) {
        EbicsResponse response = new EbicsResponse();
        response.version = version;
        return new EbicsRootParser(version.getNamespace(), response);
    }
}

