/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.response;

import de.businesslogics.ebics.schema.types.ReturnCode;
import de.businesslogics.util.StringUtils;

public class EbicsException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final ReturnCode returnCode;
    private String reportText;

    public EbicsException(ReturnCode returnCode, String message) {
        super(message);
        this.returnCode = returnCode;
    }

    public EbicsException(ReturnCode returnCode) {
        super("");
        this.returnCode = returnCode;
    }

    public ReturnCode getReturnCode() {
        return this.returnCode;
    }

    public String getReportText() {
        return this.reportText;
    }

    public void setReportText(String reportText) {
        this.reportText = reportText;
    }

    @Override
    public String getMessage() {
        StringBuilder toReturn = new StringBuilder(this.returnCode.getValue()).append(':');
        if (this.reportText != null) {
            toReturn.append(this.reportText);
        } else {
            toReturn.append(this.returnCode.getText());
        }
        if (!StringUtils.isEmpty(super.getMessage())) {
            toReturn.append(" (").append(super.getMessage()).append(')');
        }
        return toReturn.toString();
    }
}

