/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.request;

import de.businesslogics.ebics.schema.ChoiceElement;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.SequenceElement;
import de.businesslogics.ebics.schema.request.BankPubKeyDigests;
import de.businesslogics.ebics.schema.request.OrderDetails;
import de.businesslogics.ebics.schema.request.Product;
import de.businesslogics.ebics.schema.response.InvalidRequestException;
import de.businesslogics.ebics.schema.types.HostID;
import de.businesslogics.ebics.schema.types.Nonce;
import de.businesslogics.ebics.schema.types.NumSegments;
import de.businesslogics.ebics.schema.types.PartnerID;
import de.businesslogics.ebics.schema.types.SecurityMedium;
import de.businesslogics.ebics.schema.types.TimeStamp;
import de.businesslogics.ebics.schema.types.TransactionID;
import de.businesslogics.ebics.schema.types.UserID;
import org.xml.sax.SAXException;

public class Static
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private HostID hostID;
    private MyChoice choice;

    public Static() {
    }

    public Static(HostID hostID, Initialisation ini) {
        this.hostID = hostID;
        this.choice = new MyChoice(ini);
    }

    public Static(HostID hostID, TransactionID transactionID) {
        this.hostID = hostID;
        this.choice = new MyChoice(transactionID);
    }

    @Override
    public void printValue(EbicsPrintStream eps) {
        this.hostID.printOut("HostID", eps);
        this.choice.printValue(eps);
    }

    public HostID getHostID() {
        return this.hostID;
    }

    public MyChoice getC1() {
        return this.choice;
    }

    public Initialisation getInitialisation() throws InvalidRequestException {
        Initialisation toReturn = this.choice.getInitialisation();
        if (toReturn == null) {
            throw new InvalidRequestException();
        }
        return toReturn;
    }

    public TransactionID getTransactionID() throws InvalidRequestException {
        TransactionID toReturn = this.choice.getTransactionID();
        if (toReturn == null) {
            throw new InvalidRequestException();
        }
        return toReturn;
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if (parser.allowChild(0) && localName.equals("HostID")) {
                this.hostID = new HostID();
                return this.hostID;
            }
            if (!parser.allowChild(1)) {
                return null;
            }
            if (localName.equals("TransactionID") || localName.equals("Nonce") || localName.equals("PartnerID")) {
                this.choice = new MyChoice();
                return this.choice;
            }
        }
        return null;
    }

    @Override
    public void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(1);
    }

    public static class MyChoice
    extends ChoiceElement {
        private static final long serialVersionUID = 1L;

        private MyChoice() {
        }

        public MyChoice(Initialisation ini) {
            super(null, ini);
        }

        public MyChoice(TransactionID t) {
            super("TransactionID", t);
        }

        public Initialisation getInitialisation() {
            return this.get(Initialisation.class);
        }

        public TransactionID getTransactionID() {
            return this.get(TransactionID.class);
        }

        @Override
        protected EbicsElement createChild(ElementParser parser, String uri, String localName, String name) throws SAXException {
            if (parser.isParentUri(uri) && parser.allowChild(0)) {
                if (localName.equals("TransactionID")) {
                    return this.setElement(localName, new TransactionID());
                }
                if (localName.equals("Nonce") || localName.equals("PartnerID")) {
                    return this.setElement(null, new Initialisation());
                }
            }
            return null;
        }
    }

    public static class Initialisation
    extends SequenceElement {
        private static final long serialVersionUID = 1L;
        private Nonce nonce;
        private TimeStamp timeStamp;
        private PartnerID partnerID;
        private UserID userID;
        private UserID systemID;
        private Product product;
        private OrderDetails orderDetails;
        private SecurityMedium securityMedium;
        private BankPubKeyDigests bankPubKeyDigests;
        public NumSegments numSegments;

        @Deprecated
        public Initialisation() {
        }

        public Initialisation(Nonce nonce, TimeStamp timeStamp, PartnerID partnerID, UserID userID, UserID systemID, Product product, OrderDetails orderDetails, SecurityMedium securityMedium) {
            this.nonce = nonce;
            this.timeStamp = timeStamp;
            this.partnerID = partnerID;
            this.userID = userID;
            this.systemID = systemID;
            this.product = product;
            this.orderDetails = orderDetails;
            this.securityMedium = securityMedium;
        }

        public Nonce getNonce() {
            return this.nonce;
        }

        public TimeStamp getTimeStamp() {
            return this.timeStamp;
        }

        public PartnerID getPartnerID() {
            return this.partnerID;
        }

        public OrderDetails getOrderDetails() {
            return this.orderDetails;
        }

        public BankPubKeyDigests getBankPubKeyDigests() throws InvalidRequestException {
            if (this.bankPubKeyDigests == null) {
                throw new InvalidRequestException();
            }
            return this.bankPubKeyDigests;
        }

        public void setBankPubKeyDigests(BankPubKeyDigests bankPubKeyDigests) {
            this.bankPubKeyDigests = bankPubKeyDigests;
        }

        public Product getProduct() {
            return this.product;
        }

        public SecurityMedium getSecurityMedium() {
            return this.securityMedium;
        }

        public UserID getSystemID() {
            return this.systemID;
        }

        public UserID getUserID() {
            return this.userID;
        }

        public NumSegments getNumSegments() throws InvalidRequestException {
            if (this.numSegments == null) {
                throw new InvalidRequestException();
            }
            return this.numSegments;
        }

        public void setNumSegments(NumSegments numSegments) {
            this.numSegments = numSegments;
        }

        @Override
        public void printValue(EbicsPrintStream ps) {
            this.nonce.printOut("Nonce", ps);
            this.timeStamp.printOut("Timestamp", ps);
            this.partnerID.printOut("PartnerID", ps);
            this.userID.printOut("UserID", ps);
            if (this.systemID != null) {
                this.systemID.printOut("SystemID", ps);
            }
            if (this.product != null) {
                this.product.printOut("Product", ps);
            }
            this.orderDetails.printOut("OrderDetails", ps);
            if (this.bankPubKeyDigests != null) {
                this.bankPubKeyDigests.printOut("BankPubKeyDigests", ps);
            }
            this.securityMedium.printOut("SecurityMedium", ps);
            if (this.numSegments != null) {
                this.numSegments.printOut("NumSegments", ps);
            }
        }

        @Override
        protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
            if (parser.isParentUri(uri)) {
                if ("Nonce".equals(localName) && parser.allowChild(0)) {
                    this.nonce = new Nonce();
                    return this.nonce;
                }
                if ("Timestamp".equals(localName) && parser.allowChild(1)) {
                    this.timeStamp = new TimeStamp();
                    return this.timeStamp;
                }
                if ("PartnerID".equals(localName) && parser.allowChild(2)) {
                    this.partnerID = new PartnerID();
                    return this.partnerID;
                }
                if ("UserID".equals(localName) && parser.allowChild(3)) {
                    this.userID = new UserID();
                    return this.userID;
                }
                if ("SystemID".equals(localName) && parser.allowChild(4)) {
                    this.systemID = new UserID();
                    return this.systemID;
                }
                if ("Product".equals(localName) && parser.allowChild(3, 5)) {
                    this.product = new Product();
                    return this.product;
                }
                if ("OrderDetails".equals(localName) && parser.allowChild(3, 6)) {
                    this.orderDetails = new OrderDetails();
                    return this.orderDetails;
                }
                if ("BankPubKeyDigests".equals(localName) && parser.allowChild(7)) {
                    this.bankPubKeyDigests = new BankPubKeyDigests();
                    return this.bankPubKeyDigests;
                }
                if ("SecurityMedium".equals(localName) && parser.allowChild(6, 8)) {
                    this.securityMedium = new SecurityMedium();
                    return this.securityMedium;
                }
                if ("NumSegments".equals(localName) && parser.allowChild(9)) {
                    this.numSegments = new NumSegments();
                    return this.numSegments;
                }
            }
            return null;
        }

        @Override
        public void endElement(ElementParser parser) throws SAXException {
            parser.checkLastMandatory(8);
        }
    }
}

