/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.request;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.SimpleStringElement;
import java.util.Locale;
import org.xml.sax.SAXParseException;

public class Product
extends SimpleStringElement {
    private static final long serialVersionUID = 1L;
    private String language;
    private String instituteID;

    public Product(String name, Locale language, String instituteID) {
        super(name);
        this.language = language == null ? Locale.getDefault().getLanguage() : language.getLanguage();
        this.instituteID = instituteID;
    }

    public Product() {
    }

    public Locale getLocale() {
        return new Locale(this.language.toLowerCase());
    }

    public String getInstituteID() {
        return this.instituteID;
    }

    @Override
    public void setAttributes(EbicsAttributes attributes) throws SAXParseException {
        this.language = attributes.getMandatoryValue("Language");
        this.instituteID = attributes.getValue("InstituteID");
    }

    @Override
    public void addAttributes(EbicsPrintStream ps) {
        if (this.instituteID != null) {
            ps.addAttribute("InstituteID", this.instituteID);
        }
        ps.addAttribute("Language", this.language);
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXParseException {
        SimpleStringElement.StringParser sp = (SimpleStringElement.StringParser)parser;
        sp.checkLength(0, 64);
        this.value = sp.getReplaced();
    }
}

