/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.request;

import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.SimpleStringElement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.xml.sax.SAXException;

public class OrderType
extends SimpleStringElement {
    private static final long serialVersionUID = 1L;
    private static final Pattern PATTERN = Pattern.compile("[A-Z0-9]{3}");
    public static final OrderType FDL = new OrderType("FDL");
    public static final OrderType FUL = new OrderType("FUL");
    public static final OrderType HAA = new OrderType("HAA");
    public static final OrderType HAC = new OrderType("HAC");
    public static final OrderType PSR = new OrderType("PSR");
    public static final OrderType HCA = new OrderType("HCA");
    public static final OrderType HCS = new OrderType("HCS");
    public static final OrderType HIA = new OrderType("HIA");
    public static final OrderType HKD = new OrderType("HKD");
    public static final OrderType HPB = new OrderType("HPB");
    public static final OrderType HPD = new OrderType("HPD");
    public static final OrderType HSA = new OrderType("HSA");
    public static final OrderType HTD = new OrderType("HTD");
    public static final OrderType HVD = new OrderType("HVD");
    public static final OrderType HVE = new OrderType("HVE");
    public static final OrderType HVS = new OrderType("HVS");
    public static final OrderType HVT = new OrderType("HVT");
    public static final OrderType HVU = new OrderType("HVU");
    public static final OrderType HVZ = new OrderType("HVZ");
    public static final OrderType INI = new OrderType("INI");
    public static final OrderType PTK = new OrderType("PTK");
    public static final OrderType PUB = new OrderType("PUB");
    public static final OrderType SPR = new OrderType("SPR");
    public static final OrderType XCR = new OrderType("XCR");
    public static final OrderType H3K = new OrderType("H3K");
    public static final OrderType BTD = new OrderType("BTD");
    public static final OrderType BTU = new OrderType("BTU");
    public static final Set<OrderType> ADMIN30_FETCH_ORDER_TYPES;
    public static final Set<OrderType> ADMIN30_SEND_ORDER_TYPES;

    @Deprecated
    public OrderType() {
    }

    public OrderType(String orderType) {
        super(orderType);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OrderType)) {
            return false;
        }
        return this.value.equals(((OrderType)obj).value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        SimpleStringElement.StringParser sp = (SimpleStringElement.StringParser)parser;
        sp.checkPattern(PATTERN);
        this.value = sp.getCondensed();
    }

    static {
        boolean lazy = Boolean.parseBoolean(System.getProperty("de.businesslogics.ebics.schema.lazyOrderTypes", "true"));
        HashSet<OrderType> f = new HashSet<OrderType>();
        f.add(HAA);
        f.add(HAC);
        f.add(HKD);
        f.add(HPD);
        f.add(HTD);
        f.add(HVD);
        f.add(HVT);
        f.add(HVU);
        f.add(HVZ);
        if (lazy) {
            f.add(PTK);
            f.add(HPB);
            f.add(PSR);
            f.add(XCR);
        }
        ADMIN30_FETCH_ORDER_TYPES = Collections.unmodifiableSet(f);
        HashSet<OrderType> s = new HashSet<OrderType>();
        s.add(INI);
        s.add(H3K);
        s.add(HCA);
        s.add(HCS);
        s.add(HSA);
        s.add(HIA);
        s.add(HVE);
        s.add(HVS);
        s.add(PUB);
        if (lazy) {
            s.add(SPR);
        }
        ADMIN30_SEND_ORDER_TYPES = Collections.unmodifiableSet(s);
    }
}

