/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.request;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.h003.FDLOrderParams;
import de.businesslogics.ebics.schema.h003.FULOrderParams;
import de.businesslogics.ebics.schema.h005.BTDOrderParams;
import de.businesslogics.ebics.schema.h005.BTUOrderParams;
import de.businesslogics.ebics.schema.orders.GenericOrderParams;
import de.businesslogics.ebics.schema.orders.HVDOrderParams;
import de.businesslogics.ebics.schema.orders.HVEOrderParams;
import de.businesslogics.ebics.schema.orders.HVSOrderParams;
import de.businesslogics.ebics.schema.orders.HVTOrderParams;
import de.businesslogics.ebics.schema.orders.HVUOrderParams;
import de.businesslogics.ebics.schema.orders.HVZOrderParams;
import de.businesslogics.ebics.schema.orders.StandardOrderParams;
import de.businesslogics.ebics.schema.request.OrderAttribute;
import de.businesslogics.ebics.schema.request.OrderID;
import de.businesslogics.ebics.schema.request.OrderType;
import de.businesslogics.ebics.schema.response.InvalidRequestException;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import org.xml.sax.SAXException;

public class OrderDetails
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    public static boolean allowH005GenericOrderParams = false;
    private OrderType orderType;
    private OrderID orderID;
    private OrderAttribute orderAttribute;
    private EbicsElement orderParams;

    @Deprecated
    public OrderDetails() {
    }

    public OrderDetails(OrderType orderType, OrderID orderID, OrderAttribute orderAttribute, EbicsElement orderParams) {
        this.orderType = orderType;
        this.orderID = orderID;
        this.orderAttribute = orderAttribute;
        this.orderParams = orderParams;
    }

    public OrderAttribute getOrderAttribute() {
        return this.orderAttribute;
    }

    public OrderID getOrderID() {
        return this.orderID;
    }

    public OrderType getOrderType() {
        return this.orderType;
    }

    public EbicsElement getOrderParams() {
        return this.orderParams;
    }

    public <T> T getOrderParams(Class<T> clazz) throws InvalidRequestException {
        if (!clazz.isInstance(this.orderParams)) {
            throw new InvalidRequestException(clazz.getCanonicalName() + " required");
        }
        return (T)this.orderParams;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        ProtocolVersion pv = ProtocolVersion.fromNameSpace(ps.getNamespaceURI(""));
        this.orderType.printOut(pv.compareTo(ProtocolVersion.H004) <= 0 ? "OrderType" : "AdminOrderType", ps);
        ps.printOut("OrderID", this.orderID);
        ps.printOut("OrderAttribute", this.orderAttribute);
        if (this.orderParams != null) {
            this.orderParams.printOut(this.orderParams.name(), ps);
        }
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            int lm;
            ProtocolVersion protocolVersion = ProtocolVersion.fromNameSpace(uri);
            short pv = protocolVersion.getVersion();
            if (pv <= 4) {
                if ("OrderType".equals(localName) && parser.allowChild(0)) {
                    this.orderType = new OrderType();
                    return this.orderType;
                }
            } else if ("AdminOrderType".equals(localName) && parser.allowChild(0)) {
                this.orderType = new OrderType();
                return this.orderType;
            }
            if ("OrderID".equals(localName) && parser.allowChild(1)) {
                this.orderID = new OrderID();
                return this.orderID;
            }
            if (pv <= 4) {
                if ("OrderAttribute".equals(localName) && parser.allowChild(0, 2)) {
                    this.orderAttribute = new OrderAttribute();
                    return this.orderAttribute;
                }
                if ("GenericOrderParams".equals(localName) && parser.allowChild(3)) {
                    this.orderParams = new GenericOrderParams(protocolVersion);
                    return this.orderParams;
                }
                if (pv >= 3) {
                    if ("FDLOrderParams".equals(localName) && parser.allowChild(3)) {
                        this.orderParams = new FDLOrderParams();
                        return this.orderParams;
                    }
                    if ("FULOrderParams".equals(localName) && parser.allowChild(3)) {
                        this.orderParams = new FULOrderParams();
                        return this.orderParams;
                    }
                }
                lm = 2;
            } else {
                if ("BTUOrderParams".equals(localName) && parser.allowChild(0, 3)) {
                    this.orderParams = new BTUOrderParams();
                    return this.orderParams;
                }
                if ("BTDOrderParams".equals(localName) && parser.allowChild(0, 3)) {
                    this.orderParams = new BTDOrderParams();
                    return this.orderParams;
                }
                if (allowH005GenericOrderParams && "GenericOrderParams".equals(localName) && parser.allowChild(0, 3)) {
                    this.orderParams = new GenericOrderParams(protocolVersion);
                    return this.orderParams;
                }
                lm = 0;
            }
            if ("HVDOrderParams".equals(localName) && parser.allowChild(lm, 3)) {
                this.orderParams = new HVDOrderParams();
                return this.orderParams;
            }
            if ("HVEOrderParams".equals(localName) && parser.allowChild(lm, 3)) {
                this.orderParams = new HVEOrderParams();
                return this.orderParams;
            }
            if ("HVSOrderParams".equals(localName) && parser.allowChild(lm, 3)) {
                this.orderParams = new HVSOrderParams();
                return this.orderParams;
            }
            if ("HVTOrderParams".equals(localName) && parser.allowChild(lm, 3)) {
                this.orderParams = new HVTOrderParams();
                return this.orderParams;
            }
            if ("HVUOrderParams".equals(localName) && parser.allowChild(lm, 3)) {
                this.orderParams = new HVUOrderParams();
                return this.orderParams;
            }
            if ("HVZOrderParams".equals(localName) && parser.allowChild(lm, 3)) {
                this.orderParams = new HVZOrderParams();
                return this.orderParams;
            }
            if ("StandardOrderParams".equals(localName) && parser.allowChild(lm, 3)) {
                this.orderParams = new StandardOrderParams();
                return this.orderParams;
            }
        }
        return null;
    }

    @Override
    public void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(3);
    }
}

