/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.request;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.request.Mutable;
import de.businesslogics.ebics.schema.request.Static;
import org.xml.sax.SAXException;

public class Header
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private Static staticHeader;
    private Mutable mutable;

    public Header() {
    }

    public Header(Static staticHeader, Mutable mutable) {
        this.staticHeader = staticHeader;
        this.mutable = mutable;
    }

    @Override
    protected void addAttributes(EbicsPrintStream ps) {
        ps.addAttribute("authenticate", "true");
    }

    @Override
    protected void setAttributes(EbicsAttributes attributes) throws SAXException {
        super.setAttributes(attributes);
        attributes.checkFixed("authenticate", "true");
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.staticHeader.printOut("static", ps);
        this.mutable.printOut("mutable", ps);
    }

    public Static getStatic() {
        return this.staticHeader;
    }

    public Mutable getMutable() {
        return this.mutable;
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if (localName.equals("static") && parser.allowChild(0)) {
                this.staticHeader = new Static();
                return this.staticHeader;
            }
            if (localName.equals("mutable") && parser.allowChild(1)) {
                this.mutable = new Mutable();
                return this.mutable;
            }
        }
        return null;
    }

    @Override
    public void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(1);
    }
}

