/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.request;

import de.businesslogics.ebics.schema.AuthenticableRootElement;
import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.EbicsRootElement;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.request.Body;
import de.businesslogics.ebics.schema.request.Header;
import de.businesslogics.ebics.schema.response.InvalidRequestException;
import de.businesslogics.ebics.schema.signature.Signature;
import de.businesslogics.ebics.schema.types.Nonce;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.TimeStamp;
import de.businesslogics.ebics.schema.types.TransactionPhase;
import org.xml.sax.SAXException;

public class EbicsRequest
extends EbicsRootElement
implements AuthenticableRootElement {
    private static final long serialVersionUID = 1L;
    private int revision;
    private final ProtocolVersion version;
    private Header header;
    private Signature authSignature = null;
    private Body body;

    private EbicsRequest(ProtocolVersion version) {
        this.version = version;
    }

    public EbicsRequest(ProtocolVersion version, Header header, Body body) {
        this.version = version;
        this.header = header;
        this.body = body;
    }

    public int getRevision() {
        return this.revision;
    }

    @Override
    public ProtocolVersion getVersion() {
        return this.version;
    }

    public Header getHeader() {
        return this.header;
    }

    @Override
    public Signature getAuthSignature() {
        return this.authSignature;
    }

    @Override
    public void setAuthSignature(Signature signature) {
        this.authSignature = signature;
    }

    @Override
    public Nonce getNonce() throws InvalidRequestException {
        TransactionPhase tf = this.header.getMutable().getTransactionPhase();
        if (!tf.equals(TransactionPhase.INITIALIZATION)) {
            return null;
        }
        return this.header.getStatic().getInitialisation().getNonce();
    }

    @Override
    public TimeStamp getTimestamp() throws InvalidRequestException {
        TransactionPhase tf = this.header.getMutable().getTransactionPhase();
        if (!tf.equals(TransactionPhase.INITIALIZATION)) {
            return null;
        }
        return this.header.getStatic().getInitialisation().getTimeStamp();
    }

    public Body getBody() {
        return this.body;
    }

    @Override
    public String name() {
        return "ebicsRequest";
    }

    @Override
    protected void addAttributes(EbicsPrintStream ps) {
        ps.addAttribute("Version", this.version.getValue());
        ps.addAttribute("Revision", "1");
    }

    @Override
    public void setAttributes(EbicsAttributes attributes) throws SAXException {
        attributes.checkFixed("Version", this.version.getValue());
        this.revision = attributes.getInt("Revision", 1);
        if (this.revision < 1 || this.revision > 99) {
            throw new SAXException("Ebics revision=" + this.revision + " out of range");
        }
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.header.printOut("header", ps);
        if (this.authSignature != null) {
            this.authSignature.printOut("AuthSignature", ps);
        }
        this.body.printOut("body", ps);
    }

    @Override
    public void addNamespaceDecls(EbicsPrintStream ps) {
        ps.addNamespaceDecl("", this.version.getNamespace());
        ps.addNamespaceDecl("ds", "http://www.w3.org/2000/09/xmldsig#");
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if (localName.equals("header") && parser.allowChild(0)) {
                this.header = new Header();
                return this.header;
            }
            if (localName.equals("AuthSignature") && parser.allowChild(1)) {
                this.authSignature = new Signature();
                return this.authSignature;
            }
            if (localName.equals("body") && parser.allowChild(2)) {
                this.body = new Body();
                return this.body;
            }
        }
        return null;
    }

    @Override
    public void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(2);
    }

    public static ElementParser createParser(ProtocolVersion version) {
        return new EbicsRequest(version).createParser();
    }
}

