/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.request;

import de.businesslogics.ebics.schema.Base64Element;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsHandler;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.EbicsRootElement;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.h005.String255Type;
import de.businesslogics.ebics.schema.orders.UserSignatureData;
import de.businesslogics.ebics.schema.response.InvalidRequestException;
import de.businesslogics.ebics.schema.response.InvalidSignatureFileFormatException;
import de.businesslogics.ebics.schema.types.DataDigest;
import de.businesslogics.ebics.schema.types.DataEncryption;
import de.businesslogics.ebics.schema.types.EncryptionPubKeyDigest;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import de.businesslogics.ebics.schema.types.SignatureData;
import de.businesslogics.ebics.security.EncryptionHandler;
import de.businesslogics.io.Streams;
import de.businesslogics.zkasecurity.E001PublicKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.interfaces.RSAPublicKey;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.crypto.SecretKey;
import org.xml.sax.SAXException;

public class DataTransfer
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    protected DataEncryption dataEncryption;
    protected SignatureData signatureData;
    protected Base64Element orderData;
    protected DataDigest dataDigest;
    protected String255Type additionalOrderInfo;

    public DataTransfer() {
    }

    public DataTransfer(EbicsRootElement orderData) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DeflaterOutputStream gos = new DeflaterOutputStream(bos);
            EbicsPrintStream eps = new EbicsPrintStream(gos);
            eps.printOut(orderData);
            this.orderData = new Base64Element(bos.toByteArray());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.dataEncryption = null;
    }

    public DataTransfer(byte[] orderData) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DeflaterOutputStream gos = new DeflaterOutputStream(bos);
            gos.write(orderData);
            gos.close();
            this.orderData = new Base64Element(bos.toByteArray());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        this.dataEncryption = null;
    }

    public void setSignatureData(UserSignatureData usd) {
        if (usd == null) {
            this.signatureData = new SignatureData();
        } else {
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DeflaterOutputStream gos = new DeflaterOutputStream(bos);
                EbicsPrintStream eps = new EbicsPrintStream(gos);
                eps.printOut(usd);
                this.signatureData = new SignatureData(bos.toByteArray());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    public UserSignatureData getSignatureData(ProtocolVersion protocolVersion) throws InvalidSignatureFileFormatException {
        if (this.signatureData.getValue() == null) {
            return null;
        }
        try {
            return (UserSignatureData)DataTransfer.parse(UserSignatureData.createParser(protocolVersion), this.signatureData, UserSignatureData.getNamespaceSchemaLocation(protocolVersion));
        }
        catch (IOException | SAXException e) {
            InvalidSignatureFileFormatException toThrow = new InvalidSignatureFileFormatException();
            toThrow.initCause(e);
            throw toThrow;
        }
    }

    public InputStream getSignatureStream() {
        if (this.signatureData == null || this.signatureData.getValue() == null || this.signatureData.getValue().length == 0) {
            return null;
        }
        return new InflaterInputStream(new ByteArrayInputStream(this.signatureData.getValue()));
    }

    public void encrypt(EncryptionHandler handler, RSAPublicKey pubKey, byte[] keyDigest, SecretKey key) {
        try {
            OutputStream os;
            ByteArrayOutputStream bos;
            if (this.dataEncryption != null) {
                return;
            }
            if (keyDigest == null) {
                keyDigest = handler.getHash(pubKey);
            }
            if (key == null) {
                key = handler.createSecretKey();
            }
            EncryptionPubKeyDigest pubKeyDigest = handler.createPubKeyDigest(keyDigest);
            Base64Element transactionKey = new Base64Element(E001PublicKey.encrypt(pubKey, key.getEncoded()));
            this.dataEncryption = new DataEncryption(pubKeyDigest, transactionKey);
            if (this.orderData != null) {
                bos = new ByteArrayOutputStream(this.orderData.getValue().length + 32);
                os = handler.encryptContent(key, bos);
                os.write(this.orderData.getValue());
                os.close();
                this.orderData = new Base64Element(bos.toByteArray());
            }
            if (this.signatureData != null && this.signatureData.getValue() != null) {
                bos = new ByteArrayOutputStream(this.signatureData.getValue().length + 32);
                os = handler.encryptContent(key, bos);
                os.write(this.signatureData.getValue());
                os.close();
                this.signatureData = new SignatureData(bos.toByteArray());
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void decrypt(EncryptionHandler handler, SecretKey key) {
        try {
            ByteArrayOutputStream bos;
            ByteArrayInputStream src;
            if (this.orderData != null) {
                src = new ByteArrayInputStream(this.orderData.getValue());
                bos = new ByteArrayOutputStream(this.orderData.getValue().length);
                Streams.copy(handler.decryptContent(key, src), bos);
                this.orderData = new Base64Element(bos.toByteArray());
            }
            if (this.signatureData != null) {
                src = new ByteArrayInputStream(this.signatureData.getValue());
                bos = new ByteArrayOutputStream(this.signatureData.getValue().length);
                Streams.copy(handler.decryptContent(key, src), bos);
                this.signatureData = new SignatureData(bos.toByteArray());
            }
            this.dataEncryption = null;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public boolean hasOrderData() {
        return this.orderData != null;
    }

    public InputStream getOrderData() {
        return new InflaterInputStream(new ByteArrayInputStream(this.orderData.getValue()));
    }

    public byte[] getRawOrderData() {
        return this.orderData != null ? this.orderData.getValue() : null;
    }

    public void setRawOrderData(byte[] content) {
        this.orderData = content != null ? new Base64Element(content) : null;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        ps.printOut("DataEncryptionInfo", this.dataEncryption);
        ps.printOut("SignatureData", this.signatureData);
        ps.printOut("DataDigest", this.dataDigest);
        ps.printOut("AdditionalOrderInfo", this.additionalOrderInfo);
        ps.printOut("OrderData", this.orderData);
    }

    public EbicsElement parse1(ElementParser elementParser, String nssl) throws SAXException, IOException {
        return DataTransfer.parse(elementParser, this.orderData, nssl);
    }

    private static EbicsElement parse(ElementParser elementParser, Base64Element xmlData, String nssl) throws SAXException, IOException {
        if (xmlData == null) {
            throw new SAXException("Element missing");
        }
        if (xmlData.getValue() == null || xmlData.getValue().length == 0) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(xmlData.getValue());
        InflaterInputStream is = new InflaterInputStream(bis);
        return EbicsHandler.parse(is, elementParser, nssl);
    }

    @Override
    public EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if (localName.equals("DataEncryptionInfo") && parser.allowChild(0)) {
                this.dataEncryption = new DataEncryption();
                return this.dataEncryption;
            }
            if (localName.equals("SignatureData") && parser.allowChild(-1, 1)) {
                this.signatureData = new SignatureData();
                return this.signatureData;
            }
            if (localName.equals("DataDigest") && parser.allowChild(2)) {
                this.dataDigest = new DataDigest();
                return this.dataDigest;
            }
            if (localName.equals("AdditionalOrderInfo") && parser.allowChild(3)) {
                this.additionalOrderInfo = new String255Type();
                return this.additionalOrderInfo;
            }
            if ("OrderData".equals(localName) && parser.allowChild(-1, 4)) {
                this.orderData = new Base64Element();
                return this.orderData;
            }
        }
        return null;
    }

    @Override
    public void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(1);
    }

    public DataEncryption getDataEncryption() throws SAXException {
        if (this.dataEncryption == null) {
            throw new SAXException("Not encrypted");
        }
        return this.dataEncryption;
    }

    public boolean isEncrypted() {
        return this.dataEncryption != null;
    }

    public DataDigest getDataDigest() throws InvalidRequestException {
        if (this.dataDigest == null) {
            throw new InvalidRequestException();
        }
        return this.dataDigest;
    }

    public void setDataDigest(DataDigest dataDigest) {
        this.dataDigest = dataDigest;
    }

    public String255Type getAdditionalOrderInfo() {
        return this.additionalOrderInfo;
    }

    public void setAdditionalOrderInfo(String255Type additionalOrderInfo) {
        this.additionalOrderInfo = additionalOrderInfo;
    }
}

