/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.orders;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.EbicsRootElement;
import de.businesslogics.ebics.schema.EbicsRootParser;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.orders.OrderSignature;
import de.businesslogics.ebics.schema.s001.OrderSignatureDataType;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

public class UserSignatureData
extends EbicsRootElement {
    private static final long serialVersionUID = 1L;
    private final List<EbicsElement> signatures;
    private final String parentUri;

    public UserSignatureData(ProtocolVersion protocolVersion) {
        this.parentUri = UserSignatureData.getSignatureUri(protocolVersion);
        this.signatures = new ArrayList<EbicsElement>();
    }

    public List<EbicsElement> getSignatures() {
        return this.signatures;
    }

    @Override
    public void addNamespaceDecls(EbicsPrintStream eps) {
        eps.addNamespaceDecl("", this.parentUri);
    }

    @Override
    public String namespace() {
        return this.parentUri;
    }

    @Override
    public String name() {
        return "UserSignatureData";
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri) && localName.equals("OrderSignature")) {
            OrderSignature o = new OrderSignature();
            this.signatures.add(o);
            return o;
        }
        if (!uri.equals(ProtocolVersion.H002.getNamespace()) && localName.equals("OrderSignatureData")) {
            OrderSignatureDataType o = new OrderSignatureDataType();
            this.signatures.add(o);
            return o;
        }
        return null;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        for (EbicsElement os : this.signatures) {
            if (os instanceof OrderSignature) {
                os.printOut("OrderSignature", ps);
                continue;
            }
            os.printOut("OrderSignatureData", ps);
        }
    }

    public static String getSignatureUri(ProtocolVersion protocolVersion) {
        if (protocolVersion.equals(ProtocolVersion.H002)) {
            return protocolVersion.getNamespace();
        }
        if (protocolVersion.compareTo(ProtocolVersion.H004) <= 0) {
            return "http://www.ebics.org/S001";
        }
        return "http://www.ebics.org/S002";
    }

    public static String getNamespaceSchemaLocation(ProtocolVersion version) {
        switch (version.getVersion()) {
            case 2: {
                return ProtocolVersion.H002.getNamespace() + " http://www.ebics.org/H002/ebics_orders.xsd";
            }
            case 3: 
            case 4: {
                return "http://www.ebics.org/S001 http://www.ebics.org/S001/ebics_signature.xsd";
            }
        }
        return "http://www.ebics.org/S002 http://www.ebics.org/S002/ebics_signature_S002.xsd";
    }

    public static ElementParser createParser(ProtocolVersion protocolVersion) {
        UserSignatureData usd = new UserSignatureData(protocolVersion);
        return new EbicsRootParser(usd.parentUri, usd);
    }
}

