/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.orders;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.ListElement;
import de.businesslogics.ebics.schema.SimpleStringElement;
import de.businesslogics.ebics.schema.Token;
import de.businesslogics.ebics.schema.h003.FileFormat;
import de.businesslogics.ebics.schema.h005.RestrictedServiceType;
import de.businesslogics.ebics.schema.orders.Amount;
import de.businesslogics.ebics.schema.request.OrderType;
import de.businesslogics.ebics.schema.types.OrderTListType;
import de.businesslogics.ebics.schema.types.ProtocolVersion;
import org.xml.sax.SAXException;

public class UserPermission
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private EbicsElement orderTypes;
    private EbicsElement fileFormat;
    private Token account;
    private Amount maxAmount;
    private String authorisationLevel;

    @Deprecated
    public UserPermission() {
    }

    public UserPermission(ListElement<? extends SimpleStringElement> orderTypes, Token account, Amount maxAmount, String authorisationLevel) {
        this.orderTypes = orderTypes;
        this.account = account;
        this.maxAmount = maxAmount;
        this.authorisationLevel = authorisationLevel;
    }

    public UserPermission(OrderType adminOrderType, Token account, Amount maxAmount, String authorisationLevel) {
        this.orderTypes = adminOrderType;
        this.account = account;
        this.maxAmount = maxAmount;
        this.authorisationLevel = authorisationLevel;
    }

    public Token getAccount() {
        return this.account;
    }

    public String getAuthorisationLevel() {
        return this.authorisationLevel;
    }

    public Amount getMaxAmount() {
        return this.maxAmount;
    }

    public ListElement<? extends SimpleStringElement> getOrderTypes() {
        return (ListElement)this.orderTypes;
    }

    public OrderType getAdminOrderType() {
        return (OrderType)this.orderTypes;
    }

    public FileFormat getFileFormat() {
        return (FileFormat)this.fileFormat;
    }

    public void setFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    public RestrictedServiceType getService() {
        return (RestrictedServiceType)this.fileFormat;
    }

    public void setService(RestrictedServiceType service) {
        this.fileFormat = service;
    }

    @Override
    protected void addAttributes(EbicsPrintStream ps) {
        if (this.authorisationLevel != null) {
            ps.addAttribute("AuthorisationLevel", this.authorisationLevel);
        }
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        if (this.orderTypes instanceof OrderType) {
            this.orderTypes.printOut("AdminOrderType", ps);
            ps.printOut("Service", this.fileFormat);
        } else {
            this.orderTypes.printOut("OrderTypes", ps);
            ps.printOut("FileFormat", this.fileFormat);
        }
        if (this.account != null) {
            this.account.printOut("AccountID", ps);
        }
        if (this.maxAmount != null) {
            this.maxAmount.printOut("MaxAmount", ps);
        }
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            short pv = ProtocolVersion.fromNameSpace(uri).getVersion();
            if (pv <= 4) {
                if (localName.equals("OrderTypes") && parser.allowChild(0)) {
                    this.orderTypes = new OrderTListType();
                    return this.orderTypes;
                }
                if (localName.equals("FileFormat") && pv >= 4 && parser.allowChild(1)) {
                    this.fileFormat = new FileFormat();
                    return this.fileFormat;
                }
            } else {
                if (localName.equals("AdminOrderType") && parser.allowChild(0)) {
                    this.orderTypes = new OrderType();
                    return this.orderTypes;
                }
                if (localName.equals("Service") && parser.allowChild(1)) {
                    this.fileFormat = new RestrictedServiceType();
                    return this.fileFormat;
                }
            }
            if (localName.equals("AccountID") && parser.allowChild(0, 2)) {
                this.account = new Token();
                return this.account;
            }
            if (localName.equals("MaxAmount") && parser.allowChild(0, 3)) {
                this.maxAmount = new Amount();
                return this.maxAmount;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(0);
    }

    @Override
    protected void setAttributes(EbicsAttributes attributes) throws SAXException {
        this.authorisationLevel = attributes.getValue("AuthorisationLevel");
        super.setAttributes(attributes);
    }
}

