/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.orders;

import de.businesslogics.ebics.schema.EbicsAttributes;
import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.orders.UserPermission;
import de.businesslogics.ebics.schema.types.Name;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xml.sax.SAXException;

public class UserInfo
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    UserID userID;
    Name name;
    final List<UserPermission> permissions;

    public UserInfo() {
        this.permissions = new ArrayList<UserPermission>();
    }

    public UserInfo(UserID userID, List<UserPermission> permissions) {
        this.userID = userID;
        this.permissions = Collections.unmodifiableList(permissions);
    }

    public Name getName() {
        return this.name;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public List<UserPermission> getPermissions() {
        return this.permissions;
    }

    public UserID getUserID() {
        return this.userID;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.userID.printOut("UserID", ps);
        if (this.name != null) {
            this.name.printOut("Name", ps);
        }
        for (UserPermission p : this.permissions) {
            p.printOut("Permission", ps);
        }
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if (localName.equals("UserID") && parser.allowChild(0)) {
                this.userID = new UserID();
                return this.userID;
            }
            if (localName.equals("Name") && parser.allowChild(1)) {
                this.name = new Name();
                return this.name;
            }
            if (localName.equals("Permission") && parser.allowOrIsChild(0, 2)) {
                UserPermission toReturn = new UserPermission();
                this.permissions.add(toReturn);
                return toReturn;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(2);
    }

    public static class UserID
    extends de.businesslogics.ebics.schema.types.UserID {
        private static final long serialVersionUID = 1L;
        private int status;

        public UserID() {
        }

        public UserID(String id, int status) {
            super(id);
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }

        @Override
        protected void addAttributes(EbicsPrintStream ps) {
            super.addAttributes(ps);
            ps.addAttribute("Status", Integer.toString(this.status));
        }

        @Override
        protected void setAttributes(EbicsAttributes attributes) throws SAXException {
            this.status = attributes.getInt("Status");
        }
    }
}

