/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.ebics.schema.orders;

import de.businesslogics.ebics.schema.EbicsElement;
import de.businesslogics.ebics.schema.EbicsPrintStream;
import de.businesslogics.ebics.schema.ElementParser;
import de.businesslogics.ebics.schema.orders.SignerPermission;
import de.businesslogics.ebics.schema.types.Name;
import de.businesslogics.ebics.schema.types.PartnerID;
import de.businesslogics.ebics.schema.types.TimeStamp;
import de.businesslogics.ebics.schema.types.UserID;
import org.xml.sax.SAXException;

public class SignerInfo
extends EbicsElement {
    private static final long serialVersionUID = 1L;
    private PartnerID partnerID;
    private UserID userID;
    private Name name;
    private TimeStamp timestamp;
    private SignerPermission permission;

    public SignerInfo() {
    }

    public SignerInfo(PartnerID partnerID, UserID userID, Name name, TimeStamp timestamp, SignerPermission permission) {
        this.partnerID = partnerID;
        this.userID = userID;
        this.name = name;
        this.timestamp = timestamp;
        this.permission = permission;
    }

    public Name getName() {
        return this.name;
    }

    public PartnerID getPartnerID() {
        return this.partnerID;
    }

    public SignerPermission getPermission() {
        return this.permission;
    }

    public TimeStamp getTimestamp() {
        return this.timestamp;
    }

    public UserID getUserID() {
        return this.userID;
    }

    @Override
    public void printValue(EbicsPrintStream ps) {
        this.partnerID.printOut("PartnerID", ps);
        this.userID.printOut("UserID", ps);
        if (this.name != null) {
            this.name.printOut("Name", ps);
        }
        this.timestamp.printOut("Timestamp", ps);
        this.permission.printOut("Permission", ps);
    }

    @Override
    protected EbicsElement createChild(ElementParser parser, String uri, String localName, String qName) throws SAXException {
        if (parser.isParentUri(uri)) {
            if (localName.equals("PartnerID") && parser.allowChild(0)) {
                this.partnerID = new PartnerID();
                return this.partnerID;
            }
            if (localName.equals("UserID") && parser.allowChild(1)) {
                this.userID = new UserID();
                return this.userID;
            }
            if (localName.equals("Name") && parser.allowChild(2)) {
                this.name = new Name();
                return this.name;
            }
            if (localName.equals("Timestamp") && parser.allowChild(1, 3)) {
                this.timestamp = new TimeStamp();
                return this.timestamp;
            }
            if (localName.equals("Permission") && parser.allowChild(4)) {
                this.permission = new SignerPermission();
                return this.permission;
            }
        }
        return null;
    }

    @Override
    protected void endElement(ElementParser parser) throws SAXException {
        parser.checkLastMandatory(4);
    }
}

